package cn.huermao.framework.properties;


import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "we-chat")
public class WeChatProperties {

    private final WeChatProperties.MiniApp miniApp;
    private final WeChatProperties.Pay pay;

    @Autowired
    public WeChatProperties() {
        this.miniApp = new WeChatProperties.MiniApp();
        this.pay = new WeChatProperties.Pay();
    }

    public WeChatProperties.MiniApp getMiniApp() {
        return miniApp;
    }

    public WeChatProperties.Pay getPay() {
        return pay;
    }

    @Getter
    @Setter
    public class MiniApp {
        private Boolean enable = false;
        private String appId;
        private String secret;
    }

    @Getter
    @Setter
    public class Pay {
        private Boolean enable = false;
        private String appId;
        private String secret;
        private String mchId;
        private String mchKey;
        private String apiV3Key;
        private String keyPath;
        private String privateKeyPath;
        private String privateCertPath;
        private String notifyUrl;//支付回调接口
        private String refundNotifyUrl;//退款回调接口
    }
}
