package cn.huermao.framework.utils;

import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;

import java.math.BigDecimal;

/**
 * @author 胡二毛
 */
public class GeographyUtils {

    /**
     * 根据经纬度获取距离
     *
     * @param lat1 纬度1
     * @param lon1 经度1
     * @param lat2 纬度2
     * @param lon2 经度2
     * @return 米
     */
    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        GlobalCoordinates gpsFrom = new GlobalCoordinates(lat1, lon1);
        GlobalCoordinates gpsTo = new GlobalCoordinates(lat2, lon2);
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.WGS84, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }
}
