package cn.huermao.framework.validate;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author 胡二毛
 */
//注解可以用到哪些地方
@Target({ElementType.FIELD})
//指定当前注解保留到运行时
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = {ContainValidator.class})
public @interface Contain {
    boolean required() default true;

    String message() default "必须为指定值";

    String[] strValues() default {};

    int[] intValues() default {};

    byte[] byteValues() default {};

    Class<?>[] groups() default {};

    // 负载
    Class<? extends Payload>[] payload() default {};

    // 指定多个时使用
    @Target({ElementType.FIELD})
    @Retention(RetentionPolicy.RUNTIME)
    @interface List {
        Contain[] value();
    }
}
