package cn.huermao.framework.validate;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * @author 胡二毛
 */
public class ContainValidator implements ConstraintValidator<Contain, Object> {
    private static boolean require = true;
    private static String[] strValues;
    private static int[] intValues;
    private static byte[] byteValues;

    @Override
    public void initialize(Contain constraintAnnotation) {
        //第一次运行时执行
        require = constraintAnnotation.required();
        strValues = constraintAnnotation.strValues();
        intValues = constraintAnnotation.intValues();
        byteValues = constraintAnnotation.byteValues();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (require && null == value) {
            return false;
        } else if (!require && null == value) {
            return true;
        }
        if (value instanceof String) {
            for (String s : strValues) {
                if (s.equals(value)) {
                    return true;
                }
            }
        } else if (value instanceof Integer) {
            for (int s : intValues) {
                if (s == Integer.parseInt(value.toString())) {
                    return true;
                }
            }
        } else if (value instanceof Byte) {
            for (int s : byteValues) {
                if (s == Byte.parseByte(value.toString())) {
                    return true;
                }
            }
        }
        return false;
    }
}
