package cn.huermao.framework.validate;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

//注解可以用到哪些地方
@Target({ElementType.FIELD})
//指定当前注解保留到运行时
@Retention(RetentionPolicy.RUNTIME)
//校验的类
@Constraint(validatedBy = {PhoneValidator.class})
public @interface Phone {
    boolean required() default true ;
    String message() default "无效的手机号码";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
