package cn.huermao.framework.validate;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.regex.Pattern;

public class PhoneValidator implements ConstraintValidator<Phone, String> {
    private static boolean require = true;
    private static final Pattern IS_PHONE = Pattern.compile("^[1]\\d{10}$");

    @Override
    public void initialize(Phone constraintAnnotation) {
        //第一次运行时执行
        require = constraintAnnotation.required();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return !require;
        }
        return IS_PHONE.matcher(value).matches();
    }
}
