/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.Cache;
import cn.hutool.cache.CacheListener;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.CacheObjIterator;
import cn.hutool.cache.impl.CacheValuesIterator;
import cn.hutool.core.collection.CopiedIter;
import cn.hutool.core.lang.func.Func0;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    protected Map<K, CacheObj<K, V>> cacheMap;
    private final StampedLock lock = new StampedLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected AtomicLong hitCount = new AtomicLong();
    protected AtomicLong missCount = new AtomicLong();
    protected CacheListener<K, V> listener;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        long stamp = this.lock.writeLock();
        try {
            this.putWithoutLock(key, object, timeout);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private void putWithoutLock(K key, V object, long timeout) {
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(key, co);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        long stamp = this.lock.readLock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                boolean bl = false;
                return bl;
            }
            if (!co.isExpired()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        this.remove(key, true);
        return false;
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, Func0<V> supplier) {
        Object v;
        block7: {
            v = this.get(key, isUpdateLastAccess);
            if (null == v && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    CacheObj<K, V> co = this.cacheMap.get(key);
                    if (null == co || co.isExpired()) {
                        try {
                            v = supplier.call();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.put(key, v, this.timeout);
                        break block7;
                    }
                    v = co.get(isUpdateLastAccess);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key);
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess) {
        long stamp = this.lock.tryOptimisticRead();
        CacheObj<K, V> co = this.cacheMap.get(key);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                co = this.cacheMap.get(key);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        if (null == co) {
            this.missCount.getAndIncrement();
            return null;
        }
        if (!co.isExpired()) {
            this.hitCount.getAndIncrement();
            return co.get(isUpdateLastAccess);
        }
        this.remove(key, true);
        return null;
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjIterator copiedIterator = (CacheObjIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheObj<K, V>> cacheObjIterator() {
        CopiedIter copiedIterator;
        long stamp = this.lock.readLock();
        try {
            copiedIterator = CopiedIter.copyOf(this.cacheMap.values().iterator());
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return new CacheObjIterator(copiedIterator);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public void remove(K key) {
        this.remove(key, false);
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    protected void onRemove(K key, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (null != listener) {
            listener.onRemove(key, cachedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key, boolean withMissCount) {
        CacheObj<K, V> co;
        long stamp = this.lock.writeLock();
        try {
            co = this.removeWithoutLock(key, withMissCount);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    private CacheObj<K, V> removeWithoutLock(K key, boolean withMissCount) {
        CacheObj<K, V> co = this.cacheMap.remove(key);
        if (withMissCount) {
            this.missCount.getAndIncrement();
        }
        return co;
    }
}

