/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.ClassLoaderUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;

public class ResourceUtil {
    public static String readUtf8Str(String resource) {
        return new ClassPathResource(resource).readUtf8Str();
    }

    public static String readStr(String resource, Charset charset) {
        return new ClassPathResource(resource).readStr(charset);
    }

    public static InputStream getStream(String resurce) {
        return new ClassPathResource(resurce).getStream();
    }

    public static BufferedReader getReader(String resurce, Charset charset) {
        return new ClassPathResource(resurce).getReader(charset);
    }

    public static URL getResource(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassLoaderUtil.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return CollectionUtil.newArrayList(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassLoaderUtil.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        return FileUtil.isAbsolutePath(path) ? new FileResource(path) : new ClassPathResource(path);
    }
}

