/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IdcardUtil {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static Map<String, String> cityCodes = new HashMap<String, String>();
    private static Map<String, Integer> twFirstCode = new HashMap<String, Integer>();
    private static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    public static String convert15To18(String idCard) {
        if (idCard.length() != 15) {
            return null;
        }
        if (!Validator.isNumber(idCard)) {
            return null;
        }
        String birthday = idCard.substring(6, 12);
        DateTime birthDate = DateUtil.parse(birthday, "yyMMdd");
        int sYear = DateUtil.year(birthDate);
        StringBuilder idCard18 = StrUtil.builder().append(idCard.substring(0, 6)).append(sYear).append(idCard.substring(8));
        char sVal = IdcardUtil.getCheckCode18(idCard18.toString());
        idCard18.append(sVal);
        return idCard18.toString();
    }

    public static boolean isValidCard(String idCard) {
        idCard = idCard.trim();
        int length = idCard.length();
        switch (length) {
            case 18: {
                return IdcardUtil.isvalidCard18(idCard);
            }
            case 15: {
                return IdcardUtil.isvalidCard15(idCard);
            }
            case 10: {
                String[] cardval = IdcardUtil.isValidCard10(idCard);
                return cardval != null && cardval[2].equals("true");
            }
        }
        return false;
    }

    public static boolean isvalidCard18(String idCard) {
        char val;
        if (18 != idCard.length()) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        char code18 = Character.toLowerCase(idCard.charAt(17));
        return Validator.isNumber(code17) && (val = IdcardUtil.getCheckCode18(code17)) == code18;
    }

    public static boolean isvalidCard15(String idCard) {
        if (15 != idCard.length()) {
            return false;
        }
        if (Validator.isNumber(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (null == cityCodes.get(proCode)) {
                return false;
            }
            DateTime birthDate = DateUtil.parse(idCard.substring(6, 12), "yyMMdd");
            return false != Validator.isBirthday(birthDate.year(), birthDate.month(), birthDate.dayOfMonth());
        }
        return false;
    }

    public static String[] isValidCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            String char2 = idCard.substring(1, 2);
            if (char2.equals("1")) {
                info[1] = "M";
            } else if (char2.equals("2")) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IdcardUtil.isValidTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IdcardUtil.isValidHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean isValidTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = twFirstCode.get(start);
        Integer sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        Integer iflag = 8;
        for (char c : chars) {
            sum = sum + Integer.valueOf(String.valueOf(c)) * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean isValidHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        Integer sum = 0;
        if (card.length() == 9) {
            sum = (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 9 + (Integer.valueOf(card.substring(1, 2).toUpperCase().toCharArray()[0]) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer iflag = 7;
        for (char c : chars) {
            sum = sum + Integer.valueOf(String.valueOf(c)) * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        sum = "A".equals(end.toUpperCase()) ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.valueOf(end));
        return sum % 11 == 0;
    }

    public static String getBirthByIdCard(String idCard) {
        return IdcardUtil.getBirth(idCard);
    }

    public static String getBirth(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        return idCard.substring(6, 14);
    }

    public static DateTime getBirthDate(String idCard) {
        String birthByIdCard = IdcardUtil.getBirthByIdCard(idCard);
        return null == birthByIdCard ? null : DateUtil.parse(birthByIdCard, DatePattern.PURE_DATE_FORMAT);
    }

    public static int getAgeByIdCard(String idCard) {
        return IdcardUtil.getAgeByIdCard(idCard, DateUtil.date());
    }

    public static int getAgeByIdCard(String idCard, Date dateToCompare) {
        String birth = IdcardUtil.getBirthByIdCard(idCard);
        return DateUtil.age(DateUtil.parse(birth, "yyyyMMdd"), dateToCompare);
    }

    public static Short getYearByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDayByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static int getGenderByIdCard(String idCard) {
        char sCardChar;
        int sGender = -1;
        if (idCard.length() == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        sGender = Integer.parseInt(String.valueOf(sCardChar = idCard.charAt(16))) % 2 != 0 ? 1 : 0;
        return sGender;
    }

    public static String getProvinceByIdCard(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            String sProvinNum = idCard.substring(0, 2);
            return cityCodes.get(sProvinNum);
        }
        return null;
    }

    public static String hide(String idCard, int startInclude, int endExclude) {
        return StrUtil.replace((CharSequence)idCard, startInclude, endExclude, '*');
    }

    private static char getCheckCode18(String code17) {
        int sum = IdcardUtil.getPowerSum(code17.toCharArray());
        return IdcardUtil.getCheckCode18(sum);
    }

    private static char getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int getPowerSum(char[] iArr) {
        int iSum = 0;
        if (power.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.valueOf(String.valueOf(iArr[i])) * power[i];
            }
        }
        return iSum;
    }

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCode.put("A", 10);
        twFirstCode.put("B", 11);
        twFirstCode.put("C", 12);
        twFirstCode.put("D", 13);
        twFirstCode.put("E", 14);
        twFirstCode.put("F", 15);
        twFirstCode.put("G", 16);
        twFirstCode.put("H", 17);
        twFirstCode.put("J", 18);
        twFirstCode.put("K", 19);
        twFirstCode.put("L", 20);
        twFirstCode.put("M", 21);
        twFirstCode.put("N", 22);
        twFirstCode.put("P", 23);
        twFirstCode.put("Q", 24);
        twFirstCode.put("R", 25);
        twFirstCode.put("S", 26);
        twFirstCode.put("T", 27);
        twFirstCode.put("U", 28);
        twFirstCode.put("V", 29);
        twFirstCode.put("X", 30);
        twFirstCode.put("Y", 31);
        twFirstCode.put("W", 32);
        twFirstCode.put("Z", 33);
        twFirstCode.put("I", 34);
        twFirstCode.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }
}

