/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImg, File destFile, float scale) throws IORuntimeException {
        ImageUtil.write(ImageUtil.scale(srcImg, scale), destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws IORuntimeException {
        ImageUtil.scale(srcImg, ImageUtil.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        int width = NumberUtil.mul(Integer.toString(srcImg.getWidth(null)), Float.toString(scale)).intValue();
        int height = NumberUtil.mul(Integer.toString(srcImg.getHeight(null)), Float.toString(scale)).intValue();
        return ImageUtil.scale(srcImg, width, height);
    }

    public static Image scale(Image srcImg, int width, int height) {
        int srcHeight = srcImg.getHeight(null);
        int srcWidth = srcImg.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            return srcImg;
        }
        int scaleType = srcHeight < height || srcWidth < width ? 4 : 1;
        return srcImg.getScaledInstance(width, height, scaleType);
    }

    public static final void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.write(ImageUtil.read(srcImageFile), destImageFile);
    }

    public static final void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.scale(ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static final void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.scale(ImageUtil.read(srcStream), destStream, width, height, fixedColor);
    }

    public static final void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static final Image scale(Image srcImage, int width, int height, Color fixedColor) {
        double widthRatio;
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = NumberUtil.div((float)height, (float)srcHeight);
        if (heightRatio == (widthRatio = NumberUtil.div((float)width, (float)srcWidth))) {
            return ImageUtil.scale(srcImage, width, height);
        }
        Image itemp = null;
        itemp = widthRatio < (double)height ? ImageUtil.scale(srcImage, width, (int)((double)srcHeight * widthRatio)) : ImageUtil.scale(srcImage, (int)((double)srcWidth * heightRatio), height);
        if (null == fixedColor) {
            fixedColor = Color.WHITE;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(fixedColor);
        g.clearRect(0, 0, width, height);
        int itempHeight = itemp.getHeight(null);
        int itempWidth = itemp.getWidth(null);
        g.drawImage(itemp, (width - itempWidth) / 2, (height - itempHeight) / 2, itempWidth, itempHeight, fixedColor, null);
        g.dispose();
        itemp = image;
        return itemp;
    }

    public static final void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcImgFile), destImgFile, rectangle);
    }

    public static final void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcStream), destStream, rectangle);
    }

    public static final void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcStream), destStream, rectangle);
    }

    public static final void cut(Image srcImage, File destFile, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.write(ImageUtil.cut(srcImage, rectangle), destFile);
    }

    public static final void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.cut(srcImage, ImageUtil.getImageOutputStream(out), rectangle);
    }

    public static final void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.cut(srcImage, rectangle), destImageStream);
    }

    public static BufferedImage cut(Image srcImage, Rectangle rectangle) {
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(srcImage.getSource(), cropFilter));
        BufferedImage result = new BufferedImage(rectangle.width, rectangle.height, 1);
        ImageUtil.draw(result, img, new Rectangle(0, 0, rectangle.width, rectangle.height));
        return result;
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImageUtil.slice(ImageUtil.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static final void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getHeight(null);
        int srcHeight = srcImage.getWidth(null);
        try {
            if (srcWidth > destWidth && srcHeight > destHeight) {
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        BufferedImage tag = ImageUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void sliceByRowsAndCols(File srcImageFile, File descDir, int rows, int cols) {
        try {
            ImageUtil.sliceByRowsAndCols(ImageIO.read(srcImageFile), descDir, rows, cols);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void sliceByRowsAndCols(Image srcImage, File descDir, int rows, int cols) {
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getHeight();
            int srcHeight = bi.getWidth();
            if (srcWidth > 0 && srcHeight > 0) {
                int destWidth = srcWidth;
                int destHeight = srcHeight;
                destWidth = srcWidth % cols == 0 ? srcWidth / cols : (int)Math.floor(srcWidth / cols) + 1;
                destHeight = srcHeight % rows == 0 ? srcHeight / rows : (int)Math.floor(srcWidth / rows) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        BufferedImage tag = ImageUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void convert(File srcImageFile, String formatName, File destImageFile) {
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(destImageFile);
            ImageUtil.convert(ImageIO.read(srcImageFile), formatName, imageOutputStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static final void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        try {
            ImageUtil.convert(ImageIO.read(srcStream), formatName, ImageIO.createImageOutputStream(destStream));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void convert(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        try {
            ImageUtil.convert(ImageIO.read(srcStream), formatName, destStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        try {
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(srcImage), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final void gray(File srcImageFile, File destImageFile) {
        ImageUtil.gray((Image)ImageUtil.read(srcImageFile), destImageFile);
    }

    public static final void gray(InputStream srcStream, OutputStream destStream) {
        ImageUtil.gray((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream));
    }

    public static final void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImageUtil.gray((Image)ImageUtil.read(srcStream), destStream);
    }

    public static final void gray(Image srcImage, File outFile) {
        ImageUtil.write(ImageUtil.gray(srcImage), outFile);
    }

    public static final void gray(Image srcImage, OutputStream out) {
        ImageUtil.gray(srcImage, ImageUtil.getImageOutputStream(out));
    }

    public static final void gray(Image srcImage, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.gray(srcImage), destImageStream);
    }

    public static BufferedImage gray(Image srcImage) {
        BufferedImage grayImage = ImageUtil.toBufferedImage(srcImage);
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        grayImage = op.filter(grayImage, null);
        return grayImage;
    }

    public static final void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static final void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static final void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static final void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.write(ImageUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static final void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressText(srcImage, ImageUtil.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static final void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static final BufferedImage pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        BufferedImage destImage = new BufferedImage(width, height, 1);
        Graphics2D g = destImage.createGraphics();
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.setColor(color);
        g.setFont(font);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        int fontSize = font.getSize();
        g.drawString(pressText, (width - ImageUtil.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
        g.dispose();
        return destImage;
    }

    public static final void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        ImageUtil.pressImage((Image)ImageUtil.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static final void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        ImageUtil.pressImage((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static final void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressImage((Image)ImageUtil.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static final void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.write(ImageUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static final void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressImage(srcImage, ImageUtil.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static final void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static final BufferedImage pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        BufferedImage destImage = new BufferedImage(width, height, 1);
        Graphics2D g = destImage.createGraphics();
        g.drawImage(srcImage, 0, 0, width, height, null);
        int pressImgWidth = pressImg.getWidth(null);
        int pressImgHeight = pressImg.getHeight(null);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawImage(pressImg, x += (width - pressImgWidth) / 2, y += (height - pressImgHeight) / 2, pressImgWidth, pressImgHeight, null);
        g.dispose();
        return destImage;
    }

    public static void rotate(File imageFile, int degree, File outFile) throws IORuntimeException {
        ImageUtil.rotate((Image)ImageUtil.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws IORuntimeException {
        ImageUtil.write(ImageUtil.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.rotate(image, degree), ImageUtil.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.rotate(image, degree), out);
    }

    public static BufferedImage rotate(Image image, int degree) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int type = ImageUtil.toBufferedImage(image).getTransparency();
        BufferedImage destImg = new BufferedImage(width, height, type);
        Graphics2D graphics2d = destImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        return destImg;
    }

    public static void flip(File imageFile, File outFile) throws IORuntimeException {
        ImageUtil.flip((Image)ImageUtil.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws IORuntimeException {
        ImageUtil.write(ImageUtil.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws IORuntimeException {
        ImageUtil.flip(image, ImageUtil.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.flip(image), out);
    }

    public static BufferedImage flip(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage img = new BufferedImage(width, height, ImageUtil.toBufferedImage(image).getTransparency());
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        return img;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImageUtil.copyImage(img, 1);
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        byte[] decode = Base64.decode(base64, CharsetUtil.CHARSET_UTF_8);
        return ImageUtil.toImage(decode);
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        return ImageUtil.read(new ByteArrayInputStream(imageBytes));
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(fontColor);
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        ImageUtil.writePng(image, out);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_JPEG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void write(Image image, String imageType, OutputStream out) throws IORuntimeException {
        ImageUtil.write(image, imageType, ImageUtil.getImageOutputStream(out));
    }

    public static void write(Image image, String imageType, ImageOutputStream destImageStream) throws IORuntimeException {
        try {
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(image), imageType, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(Image image, File targetFile) throws IORuntimeException {
        String formatName = FileUtil.extName(targetFile);
        if (StrUtil.isBlank(formatName)) {
            formatName = IMAGE_TYPE_JPG;
        }
        try {
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage(image), formatName, targetFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(InputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(URL imageUrl) {
        try {
            return ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IORuntimeException {
        try {
            return ImageIO.createImageInputStream(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Color randomColor() {
        return ImageUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }

    private static BufferedImage draw(BufferedImage backgroundImg, Image img, Rectangle rectangle) {
        Graphics g = backgroundImg.getGraphics();
        g.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        g.dispose();
        return backgroundImg;
    }

    private static final int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }
}

