/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";

    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImageUtil.scale((Image)ImageUtil.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImg, File destFile, float scale) throws IORuntimeException {
        ImageUtil.write(ImageUtil.scale(srcImg, scale), destFile);
    }

    public static void scale(Image srcImg, OutputStream out, float scale) throws IORuntimeException {
        ImageUtil.scale(srcImg, ImageUtil.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImg, ImageOutputStream destImageStream, float scale) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.scale(srcImg, scale), destImageStream);
    }

    public static Image scale(Image srcImg, float scale) {
        return Img.from(srcImg).scale(scale).getImg();
    }

    public static Image scale(Image srcImg, int width, int height) {
        return Img.from(srcImg).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.write(ImageUtil.scale(ImageUtil.read(srcImageFile), width, height, fixedColor), destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.scale(ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.scale(ImageUtil.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws IORuntimeException {
        ImageUtil.writeJpg(ImageUtil.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Img.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImageUtil.cut((Image)ImageUtil.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.write(ImageUtil.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.cut(srcImage, ImageUtil.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.cut(srcImage, rectangle), destImageStream);
    }

    public static BufferedImage cut(Image srcImage, Rectangle rectangle) {
        return Img.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static BufferedImage cut(Image srcImage, int x, int y) {
        return ImageUtil.cut(srcImage, x, y, -1);
    }

    public static BufferedImage cut(Image srcImage, int x, int y, int radius) {
        return Img.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImageUtil.slice(ImageUtil.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getHeight(null);
        int srcHeight = srcImage.getWidth(null);
        try {
            if (srcWidth > destWidth && srcHeight > destHeight) {
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        BufferedImage tag = ImageUtil.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        try {
            ImageUtil.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, rows, cols);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        if (!destDir.exists()) {
            FileUtil.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageUtil.toBufferedImage(srcImage);
            int srcWidth = bi.getWidth();
            int srcHeight = bi.getHeight();
            int destWidth = NumberUtil.partValue(srcWidth, cols);
            int destHeight = NumberUtil.partValue(srcHeight, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    BufferedImage tag = ImageUtil.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                    ImageIO.write((RenderedImage)tag, IMAGE_TYPE_JPEG, new File(destDir, "_r" + i + "_c" + j + ".jpg"));
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileUtil.extName(srcImageFile);
        String destExtName = FileUtil.extName(destImageFile);
        if (StrUtil.equalsIgnoreCase(srcExtName, destExtName)) {
            FileUtil.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageUtil.getImageOutputStream(destImageFile);
            ImageUtil.convert(ImageUtil.read(srcImageFile), destExtName, imageOutputStream, StrUtil.equalsIgnoreCase(IMAGE_TYPE_PNG, srcExtName));
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImageUtil.write((Image)ImageUtil.read(srcStream), formatName, ImageUtil.getImageOutputStream(destStream));
    }

    @Deprecated
    public static void convert(ImageInputStream srcStream, String formatName, ImageOutputStream destStream) {
        ImageUtil.write((Image)ImageUtil.read(srcStream), formatName, destStream);
    }

    @Deprecated
    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream) {
        ImageUtil.convert(srcImage, formatName, destImageStream, false);
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImageUtil.copyImage(srcImage, 1) : ImageUtil.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImageUtil.gray((Image)ImageUtil.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImageUtil.gray((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImageUtil.gray((Image)ImageUtil.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImageUtil.write(ImageUtil.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImageUtil.gray(srcImage, ImageUtil.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.gray(srcImage), destImageStream);
    }

    public static BufferedImage gray(Image srcImage) {
        return Img.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImageUtil.binary(ImageUtil.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImageUtil.binary((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImageUtil.binary((Image)ImageUtil.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImageUtil.write(ImageUtil.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImageUtil.binary(srcImage, ImageUtil.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws IORuntimeException {
        ImageUtil.write((Image)ImageUtil.binary(srcImage), imageType, destImageStream);
    }

    public static BufferedImage binary(Image srcImage) {
        return Img.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageUtil.pressText((Image)ImageUtil.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.write(ImageUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressText(srcImage, ImageUtil.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static BufferedImage pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Img.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImg, int x, int y, float alpha) {
        ImageUtil.pressImage((Image)ImageUtil.read(srcImageFile), destImageFile, pressImg, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImg, int x, int y, float alpha) {
        ImageUtil.pressImage((Image)ImageUtil.read(srcStream), ImageUtil.getImageOutputStream(destStream), pressImg, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressImage((Image)ImageUtil.read(srcStream), destStream, pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.write(ImageUtil.pressImage(srcImage, pressImg, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.pressImage(srcImage, ImageUtil.getImageOutputStream(out), pressImg, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImg, int x, int y, float alpha) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.pressImage(srcImage, pressImg, x, y, alpha), destImageStream);
    }

    public static BufferedImage pressImage(Image srcImage, Image pressImg, int x, int y, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, x, y, alpha).getImg();
    }

    public static BufferedImage pressImage(Image srcImage, Image pressImg, Rectangle rectangle, float alpha) {
        return Img.from(srcImage).pressImage(pressImg, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws IORuntimeException {
        ImageUtil.rotate((Image)ImageUtil.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws IORuntimeException {
        ImageUtil.write(ImageUtil.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.rotate(image, degree), ImageUtil.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.rotate(image, degree), out);
    }

    public static BufferedImage rotate(Image image, int degree) {
        return Img.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws IORuntimeException {
        ImageUtil.flip((Image)ImageUtil.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws IORuntimeException {
        ImageUtil.write(ImageUtil.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws IORuntimeException {
        ImageUtil.flip(image, ImageUtil.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws IORuntimeException {
        ImageUtil.writeJpg((Image)ImageUtil.flip(image), out);
    }

    public static BufferedImage flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws IORuntimeException {
        Img.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return ImageUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImageUtil.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        BufferedImage bufferedImage;
        if (!imageType.equalsIgnoreCase(IMAGE_TYPE_PNG)) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
                if (1 != bufferedImage.getType()) {
                    bufferedImage = ImageUtil.copyImage(image, 1);
                }
            } else {
                bufferedImage = ImageUtil.copyImage(image, 1);
            }
        } else {
            bufferedImage = ImageUtil.toBufferedImage(image);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image img, int imageType) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), imageType);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws IORuntimeException {
        byte[] decode = Base64.decode(base64, CharsetUtil.CHARSET_UTF_8);
        return ImageUtil.toImage(decode);
    }

    public static BufferedImage toImage(byte[] imageBytes) throws IORuntimeException {
        return ImageUtil.read(new ByteArrayInputStream(imageBytes));
    }

    public static String toBase64(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.write(image, imageType, out);
        return Base64.encode(out.toByteArray());
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) throws IORuntimeException {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics g = image.getGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(fontColor);
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        ImageUtil.writePng((Image)image, out);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new UtilException(e);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new UtilException(e1);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        return g;
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_JPG, destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_PNG, destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_JPG, out);
    }

    public static void writePng(Image image, OutputStream out) throws IORuntimeException {
        ImageUtil.write(image, IMAGE_TYPE_PNG, out);
    }

    public static void write(Image image, String imageType, OutputStream out) throws IORuntimeException {
        ImageUtil.write(image, imageType, ImageUtil.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws IORuntimeException {
        return ImageUtil.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws IORuntimeException {
        if (StrUtil.isBlank(imageType)) {
            imageType = IMAGE_TYPE_JPG;
        }
        ImageWriter writer = ImageUtil.getWriter(image, imageType);
        return ImageUtil.write((Image)ImageUtil.toBufferedImage(image, imageType), writer, destImageStream, quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Image image, File targetFile) throws IORuntimeException {
        ImageOutputStream out = null;
        try {
            out = ImageUtil.getImageOutputStream(targetFile);
            ImageUtil.write(image, FileUtil.extName(targetFile), out);
        }
        finally {
            IoUtil.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImageUtil.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImageUtil.read(FileUtil.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(InputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage read(URL imageUrl) {
        try {
            return ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws IORuntimeException {
        try {
            return ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws IORuntimeException {
        try {
            return ImageIO.createImageInputStream(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImageUtil.toRenderedImage(img));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        String R = Integer.toHexString(color.getRed());
        R = R.length() < 2 ? '0' + R : R;
        String G = Integer.toHexString(color.getGreen());
        G = G.length() < 2 ? '0' + G : G;
        String B = Integer.toHexString(color.getBlue());
        B = B.length() < 2 ? '0' + B : B;
        return '#' + R + G + B;
    }

    public static Color hexToColor(String hex) {
        return ImageUtil.getColor(Integer.parseInt(StrUtil.removePrefix("#", hex), 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(String colorName) {
        if (StrUtil.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARK_GRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImageUtil.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImageUtil.hexToColor("#ac9c85");
        }
        if (StrUtil.startWith((CharSequence)colorName, '#')) {
            return ImageUtil.hexToColor(colorName);
        }
        if (StrUtil.startWith((CharSequence)colorName, '$')) {
            return ImageUtil.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StrUtil.split((CharSequence)colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayUtil.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImageUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }
}

