/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public class Validator {
    public static final Pattern GENERAL = PatternPool.GENERAL;
    public static final Pattern NUMBERS = PatternPool.NUMBERS;
    public static final Pattern GROUP_VAR = PatternPool.GROUP_VAR;
    public static final Pattern IPV4 = PatternPool.IPV4;
    public static final Pattern MONEY = PatternPool.MONEY;
    public static final Pattern EMAIL = PatternPool.EMAIL;
    public static final Pattern MOBILE = PatternPool.MOBILE;
    public static final Pattern CITIZEN_ID = PatternPool.CITIZEN_ID;
    public static final Pattern ZIP_CODE = PatternPool.ZIP_CODE;
    public static final Pattern BIRTHDAY = PatternPool.BIRTHDAY;
    public static final Pattern URL = PatternPool.URL;
    public static final Pattern URL_HTTP = PatternPool.URL_HTTP;
    public static final Pattern GENERAL_WITH_CHINESE = PatternPool.GENERAL_WITH_CHINESE;
    public static final Pattern UUID = PatternPool.UUID;
    public static final Pattern UUID_SIMPLE = PatternPool.UUID_SIMPLE;
    public static final Pattern PLATE_NUMBER = PatternPool.PLATE_NUMBER;

    private Validator() {
    }

    public static boolean isNull(Object value) {
        return null == value;
    }

    public static boolean isNotNull(Object value) {
        return null != value;
    }

    public static <T> T validateNotNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNull(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        return null == value || value instanceof String && StrUtil.isEmpty((String)value);
    }

    public static boolean isNotEmpty(Object value) {
        return false == Validator.isEmpty(value);
    }

    public static void validateNotEmpty(Object value, String errorMsg) throws ValidateException {
        if (Validator.isEmpty(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectUtil.equal(t1, t2);
    }

    public static void validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (!Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static boolean isMactchRegex(String regex, String value) {
        return ReUtil.isMatch(regex, (CharSequence)value);
    }

    public static void validateMatchRegex(String regex, String value, String errorMsg) throws ValidateException {
        if (!Validator.isMactchRegex(regex, value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMactchRegex(Pattern pattern, String value) {
        return ReUtil.isMatch(pattern, (CharSequence)value);
    }

    public static boolean isGeneral(String value) {
        return Validator.isMactchRegex(GENERAL, value);
    }

    public static void validateGeneral(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min, int max) {
        String reg = "^\\w{" + min + "," + max + "}$";
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMactchRegex(reg, value);
    }

    public static void validateGeneral(String value, int min, int max, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static void validateGeneral(String value, int min, String errorMsg) throws ValidateException {
        Validator.validateGeneral(value, min, 0, errorMsg);
    }

    public static boolean isLetter(String value) {
        return StrUtil.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isLetter(t.charValue());
            }
        });
    }

    public static void validateLetter(String value, String errorMsg) throws ValidateException {
        if (!Validator.isLetter(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUpperCase(String value) {
        return StrUtil.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isUpperCase(t.charValue());
            }
        });
    }

    public static void validateUpperCase(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUpperCase(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isLowerCase(String value) {
        return StrUtil.isAllCharMatch(value, new Matcher<Character>(){

            @Override
            public boolean match(Character t) {
                return Character.isLowerCase(t.charValue());
            }
        });
    }

    public static void validateLowerCase(String value, String errorMsg) throws ValidateException {
        if (!Validator.isLowerCase(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isNumber(String value) {
        return NumberUtil.isNumber(value);
    }

    public static void validateNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isNumber(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isWord(String value) {
        return Validator.isMactchRegex(PatternPool.WORD, value);
    }

    public static void validateWord(String value, String errorMsg) throws ValidateException {
        if (!Validator.isWord(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMoney(String value) {
        return Validator.isMactchRegex(MONEY, value);
    }

    public static void validateMoney(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMoney(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isZipCode(String value) {
        return Validator.isMactchRegex(ZIP_CODE, value);
    }

    public static void validateZipCode(String value, String errorMsg) throws ValidateException {
        if (!Validator.isZipCode(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isEmail(String value) {
        return Validator.isMactchRegex(EMAIL, value);
    }

    public static void validateEmail(String value, String errorMsg) throws ValidateException {
        if (!Validator.isEmail(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMobile(String value) {
        return Validator.isMactchRegex(MOBILE, value);
    }

    public static void validateMobile(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMobile(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isCitizenId(String value) {
        return Validator.isMactchRegex(CITIZEN_ID, value);
    }

    public static void validateCitizenIdNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isCitizenId(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateUtil.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day == 31) {
            return false;
        }
        return month != 2 || day <= 29 && (day != 29 || false != DateUtil.isLeapYear(year));
    }

    public static boolean isBirthday(String value) {
        java.util.regex.Matcher matcher;
        if (Validator.isMactchRegex(BIRTHDAY, value) && (matcher = BIRTHDAY.matcher(value)).find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static void validateBirthday(String value, String errorMsg) throws ValidateException {
        if (!Validator.isBirthday(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isIpv4(String value) {
        return Validator.isMactchRegex(IPV4, value);
    }

    public static void validateIpv4(String value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv4(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMac(String value) {
        return Validator.isMactchRegex(PatternPool.MAC_ADDRESS, value);
    }

    public static void validateMac(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMac(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isPlateNumber(String value) {
        return Validator.isMactchRegex(PLATE_NUMBER, value);
    }

    public static void validatePlateNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isPlateNumber(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUrl(String value) {
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static void validateUrl(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUrl(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isChinese(String value) {
        return Validator.isMactchRegex("^[\u4e00-\u9fff]+$", value);
    }

    public static void validateChinese(String value, String errorMsg) throws ValidateException {
        if (!Validator.isChinese(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneralWithChinese(String value) {
        return Validator.isMactchRegex(GENERAL_WITH_CHINESE, value);
    }

    public static void validateGeneralWithChinese(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneralWithChinese(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUUID(String value) {
        return Validator.isMactchRegex(UUID, value) || Validator.isMactchRegex(UUID_SIMPLE, value);
    }

    public static void validateUUID(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUUID(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isHex(String value) {
        return Validator.isMactchRegex(PatternPool.HEX, value);
    }

    public static void validateHex(String value, String errorMsg) throws ValidateException {
        if (!Validator.isHex(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = value.doubleValue();
        return doubleValue >= min.doubleValue() && doubleValue <= max.doubleValue();
    }

    public static void validateBetween(Number value, Number min, Number max, String errorMsg) throws ValidateException {
        if (!Validator.isBetween(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }
}

