/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.lang.MurmurHash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Simhash {
    private List<Map<String, List<Long>>> storage;
    private int bitNum = 64;
    private int fracCount;
    private int fracBitNum;
    private int hammingThresh;

    public Simhash() {
        this(4, 3);
    }

    public Simhash(int fracCount, int hammingThresh) {
        this.fracCount = fracCount;
        this.fracBitNum = this.bitNum / fracCount;
        this.hammingThresh = hammingThresh;
        this.storage = new ArrayList<Map<String, List<Long>>>(fracCount);
        for (int i = 0; i < fracCount; ++i) {
            this.storage.add(new HashMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    public long hash(Collection<? extends CharSequence> segList) {
        void var7_8;
        int bitNum = this.bitNum;
        int[] weight = new int[bitNum];
        for (CharSequence charSequence : segList) {
            long wordHash = MurmurHash.hash64(charSequence);
            for (int i = 0; i < bitNum; ++i) {
                if ((wordHash >> i & 1L) == 1L) {
                    int n = i;
                    weight[n] = weight[n] + 1;
                    continue;
                }
                int n = i;
                weight[n] = weight[n] - 1;
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        while (var7_8 < bitNum) {
            sb.append(weight[var7_8] > 0 ? 1 : 0);
            ++var7_8;
        }
        return new BigInteger(sb.toString(), 2).longValue();
    }

    public boolean equals(Collection<? extends CharSequence> segList) {
        long simhash = this.hash(segList);
        List<String> fracList = this.splitSimhash(simhash);
        int hammingThresh = this.hammingThresh;
        for (int i = 0; i < this.fracCount; ++i) {
            String frac = fracList.get(i);
            Map<String, List<Long>> fracMap = this.storage.get(i);
            if (!fracMap.containsKey(frac)) continue;
            for (Long simhash2 : fracMap.get(frac)) {
                if (this.hamming(simhash, simhash2) >= hammingThresh) continue;
                return true;
            }
        }
        return false;
    }

    public void store(Long simhash) {
        List<String> lFrac = this.splitSimhash(simhash);
        for (int i = 0; i < this.fracCount; ++i) {
            String frac = lFrac.get(i);
            Map<String, List<Long>> fracMap = this.storage.get(i);
            if (fracMap.containsKey(frac)) {
                fracMap.get(frac).add(simhash);
                continue;
            }
            ArrayList<Long> ls = new ArrayList<Long>();
            ls.add(simhash);
            fracMap.put(frac, ls);
        }
    }

    private int hamming(Long s1, Long s2) {
        int bitNum = this.bitNum;
        int dis = 0;
        for (int i = 0; i < bitNum; ++i) {
            if ((s1 >> i & 1L) == (s2 >> i & 1L)) continue;
            ++dis;
        }
        return dis;
    }

    private List<String> splitSimhash(Long simhash) {
        int bitNum = this.bitNum;
        int fracBitNum = this.fracBitNum;
        ArrayList<String> ls = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bitNum; ++i) {
            sb.append(simhash >> i & 1L);
            if ((i + 1) % fracBitNum != 0) continue;
            ls.add(sb.toString());
            sb.setLength(0);
        }
        return ls;
    }
}

