/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.BetweenFormater;
import cn.hutool.core.date.DateBetween;
import cn.hutool.core.date.DateException;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateModifier;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateRange;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Quarter;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.date.Week;
import cn.hutool.core.date.Zodiac;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtil {
    private static final String[] wtb = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime dateSecond() {
        return DateUtil.beginOfSecond(DateUtil.date());
    }

    public static DateTime date(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return DateUtil.dateNew(date);
    }

    public static DateTime dateNew(Date date) {
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return DateUtil.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String now() {
        return DateUtil.formatDateTime(new DateTime());
    }

    public static String today() {
        return DateUtil.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int quarter(Date date) {
        return DateTime.of(date).quarter();
    }

    public static Quarter quarterEnum(Date date) {
        return DateTime.of(date).quarterEnum();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static Month monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static Week dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateUtil.year(DateUtil.date());
    }

    public static int thisMonth() {
        return DateUtil.month(DateUtil.date());
    }

    public static Month thisMonthEnum() {
        return DateUtil.monthEnum(DateUtil.date());
    }

    public static int thisWeekOfYear() {
        return DateUtil.weekOfYear(DateUtil.date());
    }

    public static int thisWeekOfMonth() {
        return DateUtil.weekOfMonth(DateUtil.date());
    }

    public static int thisDayOfMonth() {
        return DateUtil.dayOfMonth(DateUtil.date());
    }

    public static int thisDayOfWeek() {
        return DateUtil.dayOfWeek(DateUtil.date());
    }

    public static Week thisDayOfWeekEnum() {
        return DateUtil.dayOfWeekEnum(DateUtil.date());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateUtil.hour(DateUtil.date(), is24HourClock);
    }

    public static int thisMinute() {
        return DateUtil.minute(DateUtil.date());
    }

    public static int thisSecond() {
        return DateUtil.second(DateUtil.date());
    }

    public static int thisMillsecond() {
        return DateUtil.millsecond(DateUtil.date());
    }

    public static String yearAndQuarter(Date date) {
        return DateUtil.yearAndQuarter(DateUtil.calendar(date));
    }

    public static LinkedHashSet<String> yearAndQuarter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return new LinkedHashSet<String>(0);
        }
        return DateUtil.yearAndQuarter(startDate.getTime(), endDate.getTime());
    }

    public static LinkedHashSet<String> yearAndQuarter(long startDate, long endDate) {
        LinkedHashSet<String> quarters = new LinkedHashSet<String>();
        Calendar cal = DateUtil.calendar(startDate);
        while (startDate <= endDate) {
            quarters.add(DateUtil.yearAndQuarter(cal));
            cal.add(2, 3);
            startDate = cal.getTimeInMillis();
        }
        return quarters;
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StrUtil.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return DateUtil.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.NORM_TIME_FORMAT.format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DatePattern.HTTP_DATETIME_FORMAT.format(date);
    }

    public static String formatChineseDate(Date date, boolean isUppercase) {
        if (null == date) {
            return null;
        }
        String format = DatePattern.CHINESE_DATE_FORMAT.format(date);
        if (isUppercase) {
            StringBuilder builder = StrUtil.builder(format.length());
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(0, 1)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(1, 2)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(2, 3)), false));
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(3, 4)), false));
            builder.append(format, 4, 5);
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(5, 7)), false));
            builder.append(format, 7, 8);
            builder.append(Convert.numberToChinese(Integer.parseInt(format.substring(8, 10)), false));
            builder.append(format.substring(10));
            format = builder.toString().replace('\u96f6', '\u3007');
        }
        return format;
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(String dateStr, String format, Locale locale) {
        return new DateTime(dateStr, new SimpleDateFormat(format, locale));
    }

    public static DateTime parseDateTime(String dateString) {
        dateString = DateUtil.normalize(dateString);
        return DateUtil.parse(dateString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseDate(String dateString) {
        dateString = DateUtil.normalize(dateString);
        return DateUtil.parse(dateString, DatePattern.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(String timeString) {
        timeString = DateUtil.normalize(timeString);
        return DateUtil.parse(timeString, DatePattern.NORM_TIME_FORMAT);
    }

    public static DateTime parseTimeToday(String timeString) {
        timeString = StrUtil.format((CharSequence)"{} {}", DateUtil.today(), timeString);
        if (1 == StrUtil.count((CharSequence)timeString, ':')) {
            return DateUtil.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return DateUtil.parse(timeString, DatePattern.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (utcString == null) {
            return null;
        }
        int length = utcString.length();
        if (StrUtil.contains(utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return DateUtil.parse(utcString, DatePattern.UTC_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length() - 4) {
                return DateUtil.parse(utcString, DatePattern.UTC_MS_FORMAT);
            }
        } else {
            if (length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ssZ".length() + 3) {
                return DateUtil.parse(utcString, DatePattern.UTC_WITH_ZONE_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 2 || length == "yyyy-MM-dd'T'HH:mm:ss.SSSZ".length() + 3) {
                return DateUtil.parse(utcString, DatePattern.UTC_MS_WITH_ZONE_OFFSET_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", utcString);
    }

    public static DateTime parseCST(String cstString) {
        if (cstString == null) {
            return null;
        }
        return DateUtil.parse(cstString, DatePattern.JDK_DATETIME_FORMAT);
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = StrUtil.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (Validator.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return DateUtil.parse(dateStr, DatePattern.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return DateUtil.parse(dateStr, DatePattern.PURE_TIME_FORMAT);
            }
        } else {
            if (ReUtil.isMatch(PatternPool.TIME, (CharSequence)dateStr)) {
                return DateUtil.parseTimeToday(dateStr);
            }
            if (StrUtil.containsAnyIgnoreCase(dateStr, wtb)) {
                return DateUtil.parseCST(dateStr);
            }
            if (StrUtil.contains(dateStr, 'T')) {
                return DateUtil.parseUTC(dateStr);
            }
        }
        if (length == "yyyy-MM-dd HH:mm:ss".length()) {
            return DateUtil.parseDateTime(dateStr);
        }
        if (length == "yyyy-MM-dd".length()) {
            return DateUtil.parseDate(dateStr);
        }
        if (length == "yyyy-MM-dd HH:mm".length()) {
            return DateUtil.parse(DateUtil.normalize(dateStr), DatePattern.NORM_DATETIME_MINUTE_FORMAT);
        }
        if (length >= "yyyy-MM-dd HH:mm:ss.SSS".length() - 2) {
            return DateUtil.parse(DateUtil.normalize(dateStr), DatePattern.NORM_DATETIME_MS_FORMAT);
        }
        throw new DateException("No format fit for date String [{}] !", dateStr);
    }

    public static DateTime truncate(Date date, DateField dateField) {
        return new DateTime(DateUtil.truncate(DateUtil.calendar(date), dateField));
    }

    public static Calendar truncate(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.TRUNCATE);
    }

    public static DateTime round(Date date, DateField dateField) {
        return new DateTime(DateUtil.round(DateUtil.calendar(date), dateField));
    }

    public static Calendar round(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.ROUND);
    }

    public static DateTime ceiling(Date date, DateField dateField) {
        return new DateTime(DateUtil.ceiling(DateUtil.calendar(date), dateField));
    }

    public static Calendar ceiling(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier.ModifyType.CEILING);
    }

    public static DateTime beginOfSecond(Date date) {
        return new DateTime(DateUtil.beginOfSecond(DateUtil.calendar(date)));
    }

    public static DateTime endOfSecond(Date date) {
        return new DateTime(DateUtil.endOfSecond(DateUtil.calendar(date)));
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return DateUtil.truncate(calendar, DateField.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return DateUtil.ceiling(calendar, DateField.SECOND);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)));
    }

    public static DateTime endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)));
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return DateUtil.truncate(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return DateUtil.ceiling(calendar, DateField.DAY_OF_MONTH);
    }

    public static DateTime beginOfWeek(Date date) {
        return new DateTime(DateUtil.beginOfWeek(DateUtil.calendar(date)));
    }

    public static DateTime endOfWeek(Date date) {
        return new DateTime(DateUtil.endOfWeek(DateUtil.calendar(date)));
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return DateUtil.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        if (isMondayAsFirstDay) {
            calendar.setFirstDayOfWeek(2);
        }
        return DateUtil.truncate(calendar, DateField.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return DateUtil.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        if (isSundayAsLastDay) {
            calendar.setFirstDayOfWeek(2);
        }
        return DateUtil.ceiling(calendar, DateField.WEEK_OF_MONTH);
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(DateUtil.beginOfMonth(DateUtil.calendar(date)));
    }

    public static DateTime endOfMonth(Date date) {
        return new DateTime(DateUtil.endOfMonth(DateUtil.calendar(date)));
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return DateUtil.truncate(calendar, DateField.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return DateUtil.ceiling(calendar, DateField.MONTH);
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(DateUtil.beginOfQuarter(DateUtil.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date) {
        return new DateTime(DateUtil.endOfQuarter(DateUtil.calendar(date)));
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return DateUtil.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateField.MONTH.getValue()) / 3 * 3 + 2);
        calendar.set(5, calendar.getActualMaximum(5));
        return DateUtil.endOfDay(calendar);
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(DateUtil.beginOfYear(DateUtil.calendar(date)));
    }

    public static DateTime endOfYear(Date date) {
        return new DateTime(DateUtil.endOfYear(DateUtil.calendar(date)));
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return DateUtil.truncate(calendar, DateField.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return DateUtil.ceiling(calendar, DateField.YEAR);
    }

    public static DateTime yesterday() {
        return DateUtil.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return DateUtil.offsetDay(new DateTime(), 1);
    }

    public static DateTime lastWeek() {
        return DateUtil.offsetWeek(new DateTime(), -1);
    }

    public static DateTime nextWeek() {
        return DateUtil.offsetWeek(new DateTime(), 1);
    }

    public static DateTime lastMonth() {
        return DateUtil.offsetMonth(new DateTime(), -1);
    }

    public static DateTime nextMonth() {
        return DateUtil.offsetMonth(new DateTime(), 1);
    }

    public static DateTime offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHour(Date date, int offset) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        return DateUtil.dateNew(date).offset(dateField, offset);
    }

    @Deprecated
    public static DateTime offsetDate(Date date, DateField dateField, int offset) {
        return DateUtil.offset(date, dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return DateUtil.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormater.Level level) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateUtil.formatBetween(DateUtil.between(beginDate, endDate, DateUnit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormater.Level level) {
        return new BetweenFormater(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormater(betweenMs, BetweenFormater.Level.MILLSECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return DateUtil.isSameDay(DateUtil.calendar(date1), DateUtil.calendar(date2));
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateUtil.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static int ageOfNow(String birthDay) {
        return DateUtil.ageOfNow(DateUtil.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateUtil.age(birthDay, DateUtil.date());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Birthday is after date {}!", DateUtil.formatDate(dateToCompare)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        boolean isLastDayOfMonth = dayOfMonth == cal.getActualMaximum(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = cal.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == cal.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static boolean isExpired(Date startDate, DateField dateField, int timeLength, Date checkedDate) {
        DateTime endDate = DateUtil.offset(startDate, dateField, timeLength);
        return endDate.after(checkedDate);
    }

    public static int timeToSecond(String timeStr) {
        if (StrUtil.isEmpty(timeStr)) {
            return 0;
        }
        List<String> hms = StrUtil.splitTrim((CharSequence)timeStr, ':', 3);
        int lastIndex = hms.size() - 1;
        int result = 0;
        for (int i = lastIndex; i >= 0; --i) {
            result = (int)((double)result + (double)Integer.parseInt(hms.get(i)) * Math.pow(60.0, lastIndex - i));
        }
        return result;
    }

    public static String secondToTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Seconds must be a positive number!");
        }
        int hour = seconds / 3600;
        int other = seconds % 3600;
        int minute = other / 60;
        int second = other % 60;
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        return CollUtil.newArrayList(DateUtil.range(start, end, unit));
    }

    public static String getZodiac(int month, int day) {
        return Zodiac.getZodiac(month, day);
    }

    public static String getChineseZodiac(int year) {
        return Zodiac.getChineseZodiac(year);
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtil.compare(date1, date2);
    }

    public static int compare(Calendar calendar1, Calendar calendar2) {
        return CompareUtil.compare(calendar1, calendar2);
    }

    public static long nanosToMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public static double nanosToSeconds(long duration) {
        return (double)duration / 1.0E9;
    }

    private static String yearAndQuarter(Calendar cal) {
        return StrUtil.builder().append(cal.get(1)).append(cal.get(2) / 3 + 1).toString();
    }

    private static String normalize(String dateStr) {
        if (StrUtil.isBlank(dateStr)) {
            return dateStr;
        }
        List<String> dateAndTime = StrUtil.splitTrim((CharSequence)dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return dateStr;
        }
        StringBuilder builder = StrUtil.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StrUtil.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StrUtil.removeSuffix(timePart, ":");
            builder.append(timePart);
        }
        return builder.toString();
    }
}

