/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch.watchers;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.Set;

public class DelayWatcher
implements Watcher {
    private final Set<Path> eventSet = new ConcurrentHashSet<Path>();
    private final Watcher watcher;
    private final long delay;

    public DelayWatcher(Watcher watcher, long delay) {
        Assert.notNull(watcher);
        if (watcher instanceof DelayWatcher) {
            throw new IllegalArgumentException("Watcher must not be a DelayWatcher");
        }
        this.watcher = watcher;
        this.delay = delay;
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        if (this.delay < 1L) {
            this.watcher.onModify(event, currentPath);
        } else {
            this.onDelayModify(event, currentPath);
        }
    }

    @Override
    public void onCreate(WatchEvent<?> event, Path currentPath) {
        this.watcher.onCreate(event, currentPath);
    }

    @Override
    public void onDelete(WatchEvent<?> event, Path currentPath) {
        this.watcher.onDelete(event, currentPath);
    }

    @Override
    public void onOverflow(WatchEvent<?> event, Path currentPath) {
        this.watcher.onOverflow(event, currentPath);
    }

    private void onDelayModify(WatchEvent<?> event, Path currentPath) {
        Path eventPath = Paths.get(currentPath.toString(), event.context().toString());
        if (this.eventSet.contains(eventPath)) {
            return;
        }
        this.eventSet.add(eventPath);
        this.startHandleModifyThread(event, currentPath);
    }

    private void startHandleModifyThread(final WatchEvent<?> event, final Path currentPath) {
        ThreadUtil.execute(new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep(DelayWatcher.this.delay);
                DelayWatcher.this.eventSet.remove(Paths.get(currentPath.toString(), event.context().toString()));
                DelayWatcher.this.watcher.onModify(event, currentPath);
            }
        });
    }
}

