/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final int INDENT_DEFAULT = 2;

    public static Document readXML(File file) {
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new UtilException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            Document document = XmlUtil.readXML(in);
            return document;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static Document readXML(String pathOrContent) {
        if (StrUtil.startWith((CharSequence)pathOrContent, '<')) {
            return XmlUtil.parseXml(pathOrContent);
        }
        return XmlUtil.readXML(FileUtil.file(pathOrContent));
    }

    public static Document readXML(InputStream inputStream) throws UtilException {
        return XmlUtil.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) throws UtilException {
        return XmlUtil.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource source) {
        DocumentBuilder builder = XmlUtil.createDocumentBuilder();
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new UtilException(e, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (StrUtil.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = XmlUtil.cleanInvalid(xmlStr);
        return XmlUtil.readXML(new InputSource(StrUtil.getReader(xmlStr)));
    }

    public static <T> T readObjectFromXml(File source) {
        return XmlUtil.readObjectFromXml(new InputSource(FileUtil.getInputStream(source)));
    }

    public static <T> T readObjectFromXml(String xmlStr) {
        return XmlUtil.readObjectFromXml(new InputSource(StrUtil.getReader(xmlStr)));
    }

    public static <T> T readObjectFromXml(InputSource source) {
        Object result;
        XMLDecoder xmldec = null;
        try {
            xmldec = new XMLDecoder(source);
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.close(xmldec);
            throw throwable;
        }
        IoUtil.close(xmldec);
        return (T)result;
    }

    public static String toStr(Document doc) {
        return XmlUtil.toStr(doc, false);
    }

    public static String toStr(Document doc, boolean isPretty) {
        return XmlUtil.toStr(doc, "UTF-8", isPretty);
    }

    public static String toStr(Document doc, String charset, boolean isPretty) {
        StringWriter writer = StrUtil.getWriter();
        try {
            XmlUtil.write((Node)doc, writer, charset, isPretty ? 2 : 0);
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
        return writer.toString();
    }

    public static String format(Document doc) {
        return XmlUtil.toStr(doc, true);
    }

    public static String format(String xmlStr) {
        return XmlUtil.format(XmlUtil.parseXml(xmlStr));
    }

    public static void toFile(Document doc, String absolutePath) {
        XmlUtil.toFile(doc, absolutePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document doc, String path, String charset) {
        if (StrUtil.isBlank(charset)) {
            charset = doc.getXmlEncoding();
        }
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(path, charset, false);
            XmlUtil.write((Node)doc, writer, charset, 2);
        }
        catch (Throwable throwable) {
            IoUtil.close(writer);
            throw throwable;
        }
        IoUtil.close(writer);
    }

    public static void write(Node node, Writer writer, String charset, int indent) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(writer), charset, indent);
    }

    public static void write(Node node, OutputStream out, String charset, int indent) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(out), charset, indent);
    }

    public static void transform(Source source, Result result, String charset, int indent) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            }
            if (StrUtil.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static Document createXml() {
        return XmlUtil.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = XmlUtil.disableXXE(DocumentBuilderFactory.newInstance());
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException(e, "Create xml document error!", new Object[0]);
        }
        return builder;
    }

    public static Document createXml(String rootElementName) {
        return XmlUtil.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace) {
        Document doc = XmlUtil.createXml();
        doc.appendChild(null == namespace ? doc.createElement(rootElementName) : doc.createElementNS(rootElementName, namespace));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = StrUtil.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static void writeObjectAsXml(File dest, Object bean) {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(FileUtil.getOutputStream(dest));
            xmlenc.writeObject(bean);
        }
        catch (Throwable throwable) {
            IoUtil.close(xmlenc);
            throw throwable;
        }
        IoUtil.close(xmlenc);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Element getElementByXPath(String expression, Object source) {
        return (Element)XmlUtil.getNodeByXPath(expression, source);
    }

    public static NodeList getNodeListByXPath(String expression, Object source) {
        return (NodeList)XmlUtil.getByXPath(expression, source, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String expression, Object source) {
        return (Node)XmlUtil.getByXPath(expression, source, XPathConstants.NODE);
    }

    public static Object getByXPath(String expression, Object source, QName returnType) {
        XPath xPath = XmlUtil.createXPath();
        try {
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, source, returnType);
        }
        catch (XPathExpressionException e) {
            throw new UtilException(e);
        }
    }

    public static String escape(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlUtil.xmlToMap(xmlStr, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlUtil.xmlToMap(node, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        Document doc = XmlUtil.parseXml(xmlStr);
        Element root = XmlUtil.getRootElement(doc);
        root.normalize();
        return XmlUtil.xmlToMap(root, result);
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node childNode = nodeList.item(i);
            if (!XmlUtil.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            result.put(childEle.getNodeName(), childEle.getTextContent());
        }
        return result;
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName));
    }

    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, rootName, namespace));
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) {
        return XmlUtil.mapToXml(data, rootName, null);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName, String namespace) {
        Document doc = XmlUtil.createXml();
        Element root = XmlUtil.appendChild(doc, rootName, namespace);
        XmlUtil.mapToXml(doc, root, data);
        return doc;
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        return XmlUtil.appendChild(node, tagName, null);
    }

    public static Element appendChild(Node node, String tagName, String namespace) {
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element child = null == namespace ? doc.createElement(tagName) : doc.createElementNS(namespace, tagName);
        node.appendChild(child);
        return child;
    }

    private static void mapToXml(Document doc, Element element, Map<?, ?> data) {
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            Object key = entry.getKey();
            if (null == key) continue;
            Element filedEle = doc.createElement(key.toString());
            element.appendChild(filedEle);
            Object value = entry.getValue();
            if (null == value) continue;
            if (value instanceof Map) {
                XmlUtil.mapToXml(doc, filedEle, (Map)value);
                element.appendChild(filedEle);
                continue;
            }
            filedEle.appendChild(doc.createTextNode(value.toString()));
        }
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }
}

