/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsoleTable {
    private static final char ROW_LINE = '-';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private final List<List<String>> HEADER_LIST = new ArrayList<List<String>>();
    private final List<List<String>> BODY_LIST = new ArrayList<List<String>>();
    private List<Integer> columnCharNumber;

    public ConsoleTable addHeader(String ... titles) {
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
        }
        ArrayList<String> l = new ArrayList<String>();
        this.fillColumns(l, titles);
        this.HEADER_LIST.add(l);
        return this;
    }

    public ConsoleTable addBody(String ... values) {
        ArrayList<String> l = new ArrayList<String>();
        this.BODY_LIST.add(l);
        this.fillColumns(l, values);
        return this;
    }

    private void fillColumns(List<String> l, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String col = Convert.toSBC(column);
            l.add(col);
            int width = col.length();
            if (width <= this.columnCharNumber.get(i)) continue;
            this.columnCharNumber.set(i, width);
        }
    }

    public String toString() {
        int j;
        int lw;
        int l;
        int i;
        StringBuilder sb = new StringBuilder();
        this.fillBorder(sb);
        for (List<String> headers : this.HEADER_LIST) {
            for (i = 0; i < headers.size(); ++i) {
                if (i == 0) {
                    sb.append('|');
                }
                String header = headers.get(i);
                sb.append('\u3000');
                sb.append(header);
                sb.append('\u3000');
                l = header.length();
                lw = this.columnCharNumber.get(i);
                if (lw > l) {
                    for (j = 0; j < lw - l; ++j) {
                        sb.append('\u3000');
                    }
                }
                sb.append('|');
            }
            sb.append('\n');
        }
        this.fillBorder(sb);
        for (List<String> bodys : this.BODY_LIST) {
            for (i = 0; i < bodys.size(); ++i) {
                if (i == 0) {
                    sb.append('|');
                }
                String body = bodys.get(i);
                sb.append('\u3000');
                sb.append(body);
                sb.append('\u3000');
                l = body.length();
                lw = this.columnCharNumber.get(i);
                if (lw > l) {
                    for (j = 0; j < lw - l; ++j) {
                        sb.append('\u3000');
                    }
                }
                sb.append('|');
            }
            sb.append('\n');
        }
        this.fillBorder(sb);
        return sb.toString();
    }

    private void fillBorder(StringBuilder sb) {
        sb.append('+');
        for (Integer width : this.columnCharNumber) {
            sb.append(Convert.toSBC(StrUtil.fillAfter("", '-', width + 2)));
            sb.append('+');
        }
        sb.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }
}

