/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.net.URLEncoder;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;

public class URLEncodeUtil {
    public static String encodeAll(String url) {
        return URLEncodeUtil.encodeAll(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeAll(String url, Charset charset) throws UtilException {
        return URLEncoder.ALL.encode(url, charset);
    }

    public static String encode(String url) throws UtilException {
        return URLEncodeUtil.encode(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String url, Charset charset) {
        return URLEncoder.DEFAULT.encode(url, charset);
    }

    public static String encodeQuery(String url) throws UtilException {
        return URLEncodeUtil.encodeQuery(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeQuery(String url, Charset charset) {
        return URLEncoder.QUERY.encode(url, charset);
    }

    public static String encodePathSegment(String url) throws UtilException {
        return URLEncodeUtil.encodePathSegment(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodePathSegment(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.PATH_SEGMENT.encode(url, charset);
    }

    public static String encodeFragment(String url) throws UtilException {
        return URLEncodeUtil.encodeFragment(url, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encodeFragment(String url, Charset charset) {
        if (StrUtil.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = CharsetUtil.defaultCharset();
        }
        return URLEncoder.FRAGMENT.encode(url, charset);
    }
}

