/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation.scanner;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface AnnotationScanner {
    default public boolean support(AnnotatedElement annotatedElement) {
        return false;
    }

    public List<Annotation> getAnnotations(AnnotatedElement var1);

    default public List<Annotation> getIfSupport(AnnotatedElement annotatedElement) {
        return this.support(annotatedElement) ? this.getAnnotations(annotatedElement) : Collections.emptyList();
    }

    public static List<Annotation> scanByAnySupported(AnnotatedElement annotatedElement, AnnotationScanner ... scanners) {
        if (ObjectUtil.isNull(annotatedElement) && ArrayUtil.isNotEmpty(scanners)) {
            return Collections.emptyList();
        }
        return Stream.of(scanners).filter(scanner -> scanner.support(annotatedElement)).findFirst().map(scanner -> scanner.getAnnotations(annotatedElement)).orElseGet(Collections::emptyList);
    }

    public static List<Annotation> scanByAllScanner(AnnotatedElement annotatedElement, AnnotationScanner ... scanners) {
        if (ObjectUtil.isNull(annotatedElement) && ArrayUtil.isNotEmpty(scanners)) {
            return Collections.emptyList();
        }
        return Stream.of(scanners).map(scanner -> scanner.getIfSupport(annotatedElement)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

