/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.collection.TransIter;
import cn.hutool.core.lang.func.Func0;
import cn.hutool.core.lang.mutable.Mutable;
import cn.hutool.core.lang.mutable.MutableObj;
import cn.hutool.core.map.WeakConcurrentMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Mutable<K>, V> rawMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();

    public SimpleCache() {
        this(new WeakConcurrentMap());
    }

    public SimpleCache(Map<Mutable<K>, V> initMap) {
        this.rawMap = initMap;
    }

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.rawMap.get(MutableObj.of(key));
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key, Func0<V> supplier) {
        return this.get(key, null, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Predicate<V> validPredicate, Func0<V> supplier) {
        V v;
        block7: {
            v = this.get(key);
            if (null != validPredicate && null != v && !validPredicate.test(v)) {
                v = null;
            }
            if (null == v && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    v = this.get(key);
                    if (null != v && (null == validPredicate || validPredicate.test(v))) break block7;
                    try {
                        v = supplier.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.put(key, v);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key);
                }
            }
        }
        return v;
    }

    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.rawMap.put(MutableObj.of(key), value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.rawMap.remove(MutableObj.of(key));
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.rawMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new TransIter<Map.Entry, Map.Entry>(this.rawMap.entrySet().iterator(), entry -> new Map.Entry<K, V>((Map.Entry)entry){
            final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
            }

            @Override
            public K getKey() {
                return ((Mutable)this.val$entry.getKey()).get();
            }

            @Override
            public V getValue() {
                return this.val$entry.getValue();
            }

            @Override
            public V setValue(V value) {
                return this.val$entry.setValue(value);
            }
        });
    }
}

