/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.dialect.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.Page;
import cn.hutool.db.StatementUtil;
import cn.hutool.db.dialect.Dialect;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.SqlBuilder;
import cn.hutool.db.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement(conn, insert);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty((Object[])entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entities[0], this.dialectName());
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), insert.getFields(), entities);
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must not be null !", (Object[])new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where(where);
        return StatementUtil.prepareStatement(conn, delete);
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must not be null !", (Object[])new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty((Object[])where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(where);
        return StatementUtil.prepareStatement(conn, update);
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        Assert.notNull((Object)query, (String)"query must not be null !", (Object[])new Object[0]);
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query);
        return StatementUtil.prepareStatement(conn, find);
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        if (query == null || StrUtil.hasBlank((CharSequence[])query.getTableNames())) {
            throw new DbRuntimeException("Table name must not be null !");
        }
        Page page = query.getPage();
        if (null == page) {
            return this.psForFind(conn, query);
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query).orderBy(page.getOrders());
        find = this.wrapPageSql(find, page);
        return StatementUtil.prepareStatement(conn, find);
    }

    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(page.getStartPosition());
    }

    @Override
    public PreparedStatement psForCount(Connection conn, Query query) throws SQLException {
        query.setFields(ListUtil.toList((Object[])new String[]{"count(1)"}));
        return this.psForFind(conn, query);
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ANSI;
    }
}

