/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.pooled;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.ds.pooled.DbConfig;
import cn.hutool.setting.Setting;
import java.util.Map;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private final Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty((Map)config)) {
            throw new DbRuntimeException("No Hutool pool config for group: [{}]", group);
        }
        DbConfig dbConfig = new DbConfig();
        String url = config.getAndRemoveStr(DSFactory.KEY_ALIAS_URL);
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        dbConfig.setUrl(url);
        String driver = config.getAndRemoveStr(DSFactory.KEY_ALIAS_DRIVER);
        dbConfig.setDriver(StrUtil.isNotBlank((CharSequence)driver) ? driver : DriverUtil.identifyDriver(url));
        dbConfig.setUser(config.getAndRemoveStr(DSFactory.KEY_ALIAS_USER));
        dbConfig.setPass(config.getAndRemoveStr(DSFactory.KEY_ALIAS_PASSWORD));
        dbConfig.setInitialSize(this.setting.getInt("initialSize", group, Integer.valueOf(0)));
        dbConfig.setMinIdle(this.setting.getInt("minIdle", group, Integer.valueOf(0)));
        dbConfig.setMaxActive(this.setting.getInt("maxActive", group, Integer.valueOf(8)));
        dbConfig.setMaxWait(this.setting.getLong("maxWait", group, Long.valueOf(6000L)));
        for (String key : DSFactory.KEY_CONN_PROPS) {
            String connValue = config.get((Object)key);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return dbConfig;
    }
}

