/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.sql;

import cn.hutool.core.builder.Builder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.Entity;
import cn.hutool.db.dialect.DialectName;
import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.ConditionBuilder;
import cn.hutool.db.sql.Direction;
import cn.hutool.db.sql.LogicalOperator;
import cn.hutool.db.sql.Order;
import cn.hutool.db.sql.Query;
import cn.hutool.db.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<String> fields = new ArrayList<String>();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        return new SqlBuilder(wrapper);
    }

    public SqlBuilder() {
    }

    public SqlBuilder(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public SqlBuilder insert(Entity entity) {
        return this.insert(entity, DialectName.ANSI);
    }

    public SqlBuilder insert(Entity entity, DialectName dialectName) {
        SqlBuilder.validateEntity(entity);
        if (null != this.wrapper) {
            entity.setTableName(this.wrapper.wrap(entity.getTableName()));
        }
        boolean isOracle = ObjectUtil.equal((Object)((Object)dialectName), (Object)((Object)DialectName.ORACLE));
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : entity.entrySet()) {
            String field = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                fieldsPart.append(", ");
                placeHolder.append(", ");
            }
            this.fields.add(field);
            fieldsPart.append(null != this.wrapper ? this.wrapper.wrap(field) : field);
            if (isOracle && value instanceof String && StrUtil.endWithIgnoreCase((CharSequence)((String)value), (CharSequence)".nextval")) {
                placeHolder.append(value);
                continue;
            }
            placeHolder.append("?");
            this.paramValues.add(value);
        }
        this.sql.append("INSERT INTO ").append(entity.getTableName()).append(" (").append((CharSequence)fieldsPart).append(") VALUES (").append(placeHolder.toString()).append(")");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(Entity entity) {
        SqlBuilder.validateEntity(entity);
        if (null != this.wrapper) {
            entity.setTableName(this.wrapper.wrap(entity.getTableName()));
        }
        this.sql.append("UPDATE ").append(entity.getTableName()).append(" SET ");
        for (Map.Entry entry : entity.entrySet()) {
            String field = (String)entry.getKey();
            if (!StrUtil.isNotBlank((CharSequence)field)) continue;
            if (this.paramValues.size() > 0) {
                this.sql.append(", ");
            }
            this.fields.add(field);
            this.sql.append(null != this.wrapper ? this.wrapper.wrap(field) : field).append(" = ? ");
            this.paramValues.add(entry.getValue());
        }
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionUtil.join(fields, (CharSequence)","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (ArrayUtil.isEmpty((Object[])tableNames) || StrUtil.hasBlank((CharSequence[])tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.wrapper) {
            tableNames = this.wrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayUtil.join((Object[])tableNames, (CharSequence)","));
        return this;
    }

    public SqlBuilder where(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.where(this.buildCondition(conditions));
        }
        return this;
    }

    @Deprecated
    public SqlBuilder where(LogicalOperator logicalOperator, Condition ... conditions) {
        return this.where(conditions);
    }

    public SqlBuilder where(String where) {
        if (StrUtil.isNotBlank((CharSequence)where)) {
            this.sql.append(" WHERE ").append(where);
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.wrapper.wrap(field)).append(" IN ").append("(").append(ArrayUtil.join((Object[])values, (CharSequence)",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayUtil.join((Object[])fields, (CharSequence)","));
        }
        return this;
    }

    @Deprecated
    public SqlBuilder having(LogicalOperator logicalOperator, Condition ... conditions) {
        return this.having(conditions);
    }

    public SqlBuilder having(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.having(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder having(String having) {
        if (StrUtil.isNotBlank((CharSequence)having)) {
            this.sql.append(" HAVING ").append(having);
        }
        return this;
    }

    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayUtil.isEmpty((Object[])orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        boolean isFirst = true;
        for (Order order : orders) {
            String field = order.getField();
            if (null != this.wrapper) {
                field = this.wrapper.wrap(field);
            }
            if (StrUtil.isBlank((CharSequence)field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (null == direction) continue;
            this.sql.append(" ").append((Object)direction);
        }
        return this;
    }

    public SqlBuilder join(String tableName, Join join) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join).append(" JOIN ");
            if (null != this.wrapper) {
                tableName = this.wrapper.wrap(tableName);
            }
            this.sql.append(tableName);
        }
        return this;
    }

    @Deprecated
    public SqlBuilder on(LogicalOperator logicalOperator, Condition ... conditions) {
        return this.on(conditions);
    }

    public SqlBuilder on(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.on(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder on(String on) {
        if (StrUtil.isNotBlank((CharSequence)on)) {
            this.sql.append(" ON ").append(on);
        }
        return this;
    }

    public SqlBuilder insertPreFragment(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.insert(0, sqlFragment);
        }
        return this;
    }

    public SqlBuilder append(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.append(sqlFragment);
        }
        return this;
    }

    public SqlBuilder query(Query query) {
        return this.select(query.getFields()).from(query.getTableNames()).where(LogicalOperator.AND, query.getWhere());
    }

    public String[] getFieldArray() {
        return this.fields.toArray(new String[0]);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[0]);
    }

    public String build() {
        return this.sql.toString();
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(Condition ... conditions) {
        if (ArrayUtil.isEmpty((Object[])conditions)) {
            return "";
        }
        if (null != this.wrapper) {
            conditions = this.wrapper.wrap(conditions);
        }
        return ConditionBuilder.of(conditions).build(this.paramValues);
    }

    private static void validateEntity(Entity entity) throws DbRuntimeException {
        if (null == entity) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank((CharSequence)entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

