/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.compress.extractor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;

public interface Extractor
extends Closeable {
    default public void extract(File targetDir) {
        this.extract(targetDir, null);
    }

    default public void extract(File targetDir, Filter<ArchiveEntry> filter) {
        this.extract(targetDir, 0, filter);
    }

    default public void extract(File targetDir, int stripComponents) {
        this.extract(targetDir, stripComponents, null);
    }

    public void extract(File var1, int var2, Filter<ArchiveEntry> var3);

    default public String stripName(String name, int stripComponents) {
        if (stripComponents <= 0) {
            return name;
        }
        List nameList = StrUtil.splitTrim((CharSequence)name, (CharSequence)"/");
        int size = nameList.size();
        if (size > stripComponents) {
            nameList = CollUtil.sub((List)nameList, (int)stripComponents, (int)size);
            return CollUtil.join((Iterable)nameList, (CharSequence)"/");
        }
        return null;
    }

    @Override
    public void close();
}

