/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONStrFormater;
import cn.hutool.json.JSONString;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public final class JSONUtil {
    public static JSONObject createObj() {
        return new JSONObject();
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONObject parseObj(String jsonStr) {
        return new JSONObject(jsonStr);
    }

    public static JSONObject parseObj(Object obj) {
        return new JSONObject(obj);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        return new JSONObject(obj, ignoreNullValue);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue, boolean isOrder) {
        return new JSONObject(obj, ignoreNullValue, isOrder);
    }

    public static JSONArray parseArray(String jsonStr) {
        return new JSONArray(jsonStr);
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return new JSONArray(arrayOrCollection);
    }

    public static JSONArray parseArray(Object arrayOrCollection, boolean ignoreNullValue) {
        return new JSONArray(arrayOrCollection, ignoreNullValue);
    }

    public static JSON parse(Object obj) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        JSON json = obj instanceof JSON ? (JSON)obj : (obj instanceof String ? ((jsonStr = ((String)obj).trim()).startsWith("[") ? JSONUtil.parseArray(jsonStr) : JSONUtil.parseObj(jsonStr)) : (obj instanceof Collection || obj.getClass().isArray() ? new JSONArray(obj) : new JSONObject(obj)));
        return json;
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return XML.toJSONObject(xmlStr);
    }

    public static JSONObject parseFromMap(Map<?, ?> map) {
        return new JSONObject(map);
    }

    public static JSONObject parseFromResourceBundle(ResourceBundle bundle) {
        JSONObject jsonObject = new JSONObject();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(jsonObject, key, bundle.getString(key));
        }
        return jsonObject;
    }

    public static JSON readJSON(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parse(FileReader.create((File)file, (Charset)charset).readString());
    }

    public static JSONObject readJSONObject(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseObj(FileReader.create((File)file, (Charset)charset).readString());
    }

    public static JSONArray readJSONArray(File file, Charset charset) throws IORuntimeException {
        return JSONUtil.parseArray(FileReader.create((File)file, (Charset)charset).readString());
    }

    public static String toJsonStr(JSON json, int indentFactor) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(indentFactor);
    }

    public static String toJsonStr(JSON json) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(0);
    }

    public static String toJsonPrettyStr(JSON json) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(4);
    }

    public static String toJsonStr(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return JSONUtil.toJsonStr(JSONUtil.parse(obj));
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.toJsonPrettyStr(JSONUtil.parse(obj));
    }

    public static String toXmlStr(JSON json) {
        return XML.toXml(json);
    }

    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        return JSONUtil.toBean(JSONUtil.parseObj(jsonString), beanClass);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass) {
        return null == json ? null : (T)json.toBean(beanClass);
    }

    public static <T> T toBean(String jsonString, TypeReference<T> typeReference, boolean ignoreError) {
        return JSONUtil.toBean(jsonString, typeReference.getType(), ignoreError);
    }

    public static <T> T toBean(String jsonString, Type beanType, boolean ignoreError) {
        return JSONUtil.toBean(JSONUtil.parse(jsonString), beanType, ignoreError);
    }

    public static <T> T toBean(JSON json, TypeReference<T> typeReference, boolean ignoreError) {
        return JSONUtil.toBean(json, typeReference.getType(), ignoreError);
    }

    public static <T> T toBean(JSON json, Type beanType, boolean ignoreError) {
        if (null == json) {
            return null;
        }
        return json.toBean(beanType, ignoreError);
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return null == jsonArray ? null : jsonArray.toList(elementType);
    }

    public static Object getByPath(JSON json, String expression) {
        return null == json || StrUtil.isBlank((CharSequence)expression) ? null : json.getByPath(expression);
    }

    public static void putByPath(JSON json, String expression, Object value) {
        json.putByPath(expression, value);
    }

    public static String quote(String string) {
        return JSONUtil.quote(string, true);
    }

    public static String quote(String string, boolean isWrap) {
        StringWriter sw = new StringWriter();
        try {
            return JSONUtil.quote(string, sw, isWrap).toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public static Writer quote(String str, Writer writer) throws IOException {
        return JSONUtil.quote(str, writer, true);
    }

    public static Writer quote(String str, Writer writer, boolean isWrap) throws IOException {
        if (StrUtil.isEmpty((CharSequence)str)) {
            if (isWrap) {
                writer.write("\"\"");
            }
            return writer;
        }
        char c = '\u0000';
        int len = str.length();
        if (isWrap) {
            writer.write(34);
        }
        block4: for (int i = 0; i < len; ++i) {
            char b = c;
            c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write("\\");
                    writer.write(c);
                    continue block4;
                }
                case '/': {
                    if (b == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block4;
                }
                default: {
                    writer.write(JSONUtil.escape(c));
                }
            }
        }
        if (isWrap) {
            writer.write(34);
        }
        return writer;
    }

    public static String escape(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return str;
        }
        int len = str.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            builder.append(JSONUtil.escape(c));
        }
        return builder.toString();
    }

    public static Object wrap(Object object, JSONConfig jsonConfig) {
        Type jsonType;
        if (object == null) {
            return jsonConfig.isIgnoreNullValue() ? null : JSONNull.NULL;
        }
        if (object instanceof JSON || JSONNull.NULL.equals(object) || object instanceof JSONString || object instanceof CharSequence || object instanceof Number || ObjectUtil.isBasicType((Object)object)) {
            return object;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(object.getClass());
        if (null != serializer && null != (jsonType = TypeUtil.getTypeArgument(serializer.getClass()))) {
            if (serializer instanceof JSONObjectSerializer) {
                serializer.serialize(new JSONObject(jsonConfig), object);
            } else if (serializer instanceof JSONArraySerializer) {
                serializer.serialize(new JSONArray(jsonConfig), object);
            }
        }
        try {
            if (object instanceof Iterable || ArrayUtil.isArray((Object)object)) {
                return new JSONArray(object, jsonConfig);
            }
            if (object instanceof Map) {
                return new JSONObject(object, jsonConfig);
            }
            if (object instanceof Date || object instanceof Calendar || object instanceof TemporalAccessor) {
                return object;
            }
            if (object instanceof Enum) {
                return object.toString();
            }
            if (ClassUtil.isJdkClass(object.getClass())) {
                return object.toString();
            }
            return new JSONObject(object, jsonConfig);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormater.format(jsonStr);
    }

    public static boolean isJson(String str) {
        return JSONUtil.isJsonObj(str) || JSONUtil.isJsonArray(str);
    }

    public static boolean isJsonObj(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)str.trim(), (char)'{', (char)'}');
    }

    public static boolean isJsonArray(String str) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)str.trim(), (char)'[', (char)']');
    }

    public static boolean isNull(Object obj) {
        return null == obj || obj instanceof JSONNull;
    }

    public static JSONObject xmlToJson(String xml) {
        return XML.toJSONObject(xml);
    }

    public static void putSerializer(Type type, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.put(type, serializer);
    }

    public static void putSerializer(Type type, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.put(type, serializer);
    }

    public static void putDeserializer(Type type, JSONDeserializer<?> deserializer) {
        GlobalSerializeMapping.put(type, deserializer);
    }

    private static String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
            return HexUtil.toUnicodeHex((char)c);
        }
        return Character.toString(c);
    }
}

