/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.SheetDataSaxHandler;
import cn.hutool.poi.excel.sax.SheetRidReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private static final String RID_PREFIX = "rId";
    private final SheetDataSaxHandler handler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.handler = new SheetDataSaxHandler(rowHandler);
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.handler.setRowHandler(rowHandler);
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws POIException {
        return this.read(file, RID_PREFIX + rid);
    }

    @Override
    public Excel07SaxReader read(File file, String idOrRid) throws POIException {
        try {
            return this.read(OPCPackage.open((File)file), idOrRid);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws POIException {
        return this.read(in, RID_PREFIX + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(InputStream in, String idOrRid) throws POIException {
        try (OPCPackage opcPackage = OPCPackage.open((InputStream)in);){
            Excel07SaxReader excel07SaxReader = this.read(opcPackage, idOrRid);
            return excel07SaxReader;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws POIException {
        return this.read(opcPackage, RID_PREFIX + rid);
    }

    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRid) throws POIException {
        try {
            return this.read(new XSSFReader(opcPackage), idOrRid);
        }
        catch (OpenXML4JException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRid) throws POIException {
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {
            // empty catch block
        }
        try {
            this.handler.sharedStringsTable = xssfReader.getSharedStringsTable();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
        return this.readSheets(xssfReader, idOrRid);
    }

    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRid) throws POIException {
        SheetRidReader ridReader;
        String rid;
        if (NumberUtil.isInteger((String)idOrRid) && StrUtil.isNotEmpty((CharSequence)(rid = (ridReader = new SheetRidReader()).read(xssfReader).getRidBySheetId(idOrRid)))) {
            idOrRid = rid;
        }
        this.handler.sheetIndex = Integer.parseInt(StrUtil.removePrefixIgnoreCase((CharSequence)idOrRid, (CharSequence)RID_PREFIX));
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex > -1) {
                sheetInputStream = xssfReader.getSheet(RID_PREFIX + (this.handler.sheetIndex + 1));
                ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            IoUtil.close(sheetInputStream);
        }
        return this;
    }
}

