/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.poi.excel.sax.handler.AbstractRowHandler;
import java.io.Serializable;
import java.util.List;

public abstract class BeanRowHandler<T>
extends AbstractRowHandler<T> {
    private final int headerRowIndex;
    List<String> headerList;

    public BeanRowHandler(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> clazz) {
        super(startRowIndex, endRowIndex);
        Assert.isTrue((headerRowIndex <= startRowIndex ? 1 : 0) != 0, (String)"Header row must before the start row!", (Object[])new Object[0]);
        this.headerRowIndex = headerRowIndex;
        this.convertFunc = (Func1 & Serializable)rowList -> BeanUtil.toBean((Object)IterUtil.toMap(this.headerList, (Iterable)rowList), (Class)clazz);
    }

    @Override
    public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
        if (rowIndex == (long)this.headerRowIndex) {
            this.headerList = ListUtil.unmodifiable((List)Convert.toList(String.class, rowCells));
            return;
        }
        super.handle(sheetIndex, rowIndex, rowCells);
    }
}

