/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting.dialect;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.getter.BasicTypeGetter;
import cn.hutool.core.getter.OptBasicTypeGetter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.io.resource.UrlResource;
import cn.hutool.core.io.watch.SimpleWatcher;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.WatchUtil;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.hutool.log.StaticLog;
import cn.hutool.setting.SettingRuntimeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class Props
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    private static final Log log = LogFactory.get();
    private URL propertiesFileUrl;
    private WatchMonitor watchMonitor;
    private Charset charset = CharsetUtil.CHARSET_ISO_8859_1;

    public static Props getProp(String resource) {
        return new Props(resource);
    }

    public static Props getProp(String resource, String charsetName) {
        return new Props(resource, charsetName);
    }

    public static Props getProp(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public Props() {
    }

    public Props(String path) {
        this(path, CharsetUtil.CHARSET_ISO_8859_1);
    }

    public Props(String path, String charsetName) {
        this(path, CharsetUtil.charset((String)charsetName));
    }

    public Props(String path, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResourceObj((String)path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    public Props(File propertiesFile, String charsetName) {
        this(propertiesFile, Charset.forName(charsetName));
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        this.charset = charset;
        this.load((Resource)new FileResource(propertiesFile));
    }

    public Props(String path, Class<?> clazz) {
        this(path, clazz, "ISO-8859-1");
    }

    public Props(String path, Class<?> clazz, String charsetName) {
        this(path, clazz, CharsetUtil.charset((String)charsetName));
    }

    public Props(String path, Class<?> clazz, Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new ClassPathResource(path, clazz));
    }

    public Props(URL propertiesUrl) {
        this(propertiesUrl, StandardCharsets.ISO_8859_1);
    }

    public Props(URL propertiesUrl, String charsetName) {
        this(propertiesUrl, CharsetUtil.charset((String)charsetName));
    }

    public Props(URL propertiesUrl, Charset charset) {
        Assert.notNull((Object)propertiesUrl, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load((Resource)new UrlResource(propertiesUrl));
    }

    public Props(Properties properties) {
        if (CollectionUtil.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(Resource urlResource) {
        this.propertiesFileUrl = urlResource.getUrl();
        if (null == this.propertiesFileUrl) {
            throw new SettingRuntimeException("Can not find properties file: [{}]", urlResource);
        }
        log.debug("Load properties [{}]", new Object[]{this.propertiesFileUrl.getPath()});
        try (BufferedReader reader = urlResource.getReader(this.charset);){
            super.load(reader);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Load properties error!", new Object[0]);
        }
    }

    public void load() {
        this.load((Resource)new UrlResource(this.propertiesFileUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.propertiesFileUrl, (String)"Properties URL is null !", (Object[])new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify((URL)this.propertiesFileUrl, (Watcher)new SimpleWatcher(){

                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoUtil.close((Closeable)this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public Object getObj(String key, Object defaultValue) {
        return this.getStr(key, null == defaultValue ? null : defaultValue.toString());
    }

    public Object getObj(String key) {
        return this.getObj(key, null);
    }

    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    public String getStr(String key) {
        return super.getProperty(key);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt((Object)this.getStr(key), (Integer)defaultValue);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Boolean getBool(String key, Boolean defaultValue) {
        return Convert.toBool((Object)this.getStr(key), (Boolean)defaultValue);
    }

    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong((Object)this.getStr(key), (Long)defaultValue);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Character getChar(String key, Character defaultValue) {
        String value = this.getStr(key);
        if (StrUtil.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Character getChar(String key) {
        return this.getChar(key, null);
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat((Object)this.getStr(key), (Float)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble((Object)this.getStr(key), (Double)defaultValue);
    }

    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, null);
    }

    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort((Object)this.getStr(key), (Short)defaultValue);
    }

    public Short getShort(String key) {
        return this.getShort(key, null);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte((Object)this.getStr(key), (Byte)defaultValue);
    }

    public Byte getByte(String key) {
        return this.getByte(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StrUtil.isBlank((CharSequence)valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, null);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return (E)Convert.toEnum(clazz, (Object)this.getStr(key), defaultValue);
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        return Convert.toDate((Object)this.getStr(key), (Date)defaultValue);
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ReflectUtil.newInstanceIfPossible(beanClass);
        return (T)this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StrUtil.addSuffixIfNot((CharSequence)prefix, (CharSequence)".");
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanUtil.setProperty(bean, (String)StrUtil.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                StaticLog.debug((String)"Ignore property: [{}]", (Object[])new Object[]{key});
            }
        }
        return bean;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter((String)absolutePath, (Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e, "Store properties to [{}] error!", new Object[]{absolutePath});
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath((String)path, clazz));
    }
}

