/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.socket.nio;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.socket.SocketRuntimeException;
import cn.hutool.socket.nio.ChannelHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class NioClient
implements Closeable {
    private Selector selector;
    private SocketChannel channel;
    private ChannelHandler handler;

    public NioClient(String host, int port) {
        this.init(new InetSocketAddress(host, port));
    }

    public NioClient(InetSocketAddress address) {
        this.init(address);
    }

    public NioClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(address);
            this.selector = Selector.open();
            this.channel.register(this.selector, 1);
            while (!this.channel.finishConnect()) {
            }
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public NioClient setChannelHandler(ChannelHandler handler) {
        this.handler = handler;
        return this;
    }

    public void listen() {
        ThreadUtil.execute(() -> {
            try {
                this.doListen();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void doListen() throws IOException {
        while (this.selector.isOpen() && 0 != this.selector.select()) {
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (keyIter.hasNext()) {
                this.handle(keyIter.next());
                keyIter.remove();
            }
        }
    }

    private void handle(SelectionKey key) {
        if (key.isReadable()) {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            try {
                this.handler.handle(socketChannel);
            }
            catch (Exception e) {
                throw new SocketRuntimeException(e);
            }
        }
    }

    public NioClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.selector);
        IoUtil.close((Closeable)this.channel);
    }
}

