/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.metadata.data.ImageData;
import java.util.HashMap;
import java.util.Map;

public class FileTypeUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int IMAGE_TYPE_MARK_LENGTH = 28;
    private static final Map<String, ImageData.ImageType> FILE_TYPE_MAP;
    public static ImageData.ImageType defaultImageType;

    public static int getImageTypeFormat(byte[] image) {
        ImageData.ImageType imageType = FileTypeUtils.getImageType(image);
        if (imageType != null) {
            return imageType.getValue();
        }
        return defaultImageType.getValue();
    }

    public static ImageData.ImageType getImageType(byte[] image) {
        if (image == null || image.length <= 28) {
            return null;
        }
        byte[] typeMarkByte = new byte[28];
        System.arraycopy(image, 0, typeMarkByte, 0, 28);
        return FILE_TYPE_MAP.get(FileTypeUtils.encodeHexStr(typeMarkByte));
    }

    private static String encodeHexStr(byte[] data) {
        int len = data.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    static {
        defaultImageType = ImageData.ImageType.PICTURE_TYPE_PNG;
        FILE_TYPE_MAP = new HashMap<String, ImageData.ImageType>();
        FILE_TYPE_MAP.put("ffd8ff", ImageData.ImageType.PICTURE_TYPE_JPEG);
        FILE_TYPE_MAP.put("89504e47", ImageData.ImageType.PICTURE_TYPE_PNG);
    }
}

