/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.builder;

import cn.idev.excel.ExcelWriter;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.write.builder.AbstractExcelWriterParameterBuilder;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.WriteTable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

public class ExcelWriterTableBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterTableBuilder, WriteTable> {
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private final WriteTable writeTable;

    public ExcelWriterTableBuilder() {
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder(ExcelWriter excelWriter, WriteSheet writeSheet) {
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
        this.writeTable = new WriteTable();
    }

    public ExcelWriterTableBuilder tableNo(Integer tableNo) {
        this.writeTable.setTableNo(tableNo);
        return this;
    }

    public ExcelWriterTableBuilder tableNoIfNotNull(Integer tableNo) {
        if (Objects.nonNull(tableNo)) {
            this.writeTable.setTableNo(tableNo);
        }
        return this;
    }

    public WriteTable build() {
        return this.writeTable;
    }

    public void doWrite(Collection<?> data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.write().sheet().table()' to call this method");
        }
        this.excelWriter.write(data, this.writeSheet, this.build());
        this.excelWriter.finish();
    }

    public void doWrite(Supplier<Collection<?>> supplier) {
        this.doWrite(supplier.get());
    }

    @Override
    protected WriteTable parameter() {
        return this.writeTable;
    }
}

