package cn.iisme.framework.aop;

import java.lang.reflect.Method;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import cn.iisme.framework.utils.JsonUtils;
import cn.iisme.framework.utils.RedisLockUtils;
import cn.iisme.starter.redis.common.lock.RedisLock;

@Aspect
@Component
public class NoDuplicateAop {

	private static final Logger LOGGER = LoggerFactory.getLogger(NoDuplicateAop.class);

	@Pointcut("@annotation(cn.iisme.framework.aop.NoDuplicate)")
	public void duplicate() {
	}

	/**
	 * 对方法拦截后进行参数验证
	 * 
	 * @param pjp
	 * @return
	 * @throws Throwable
	 */
	@Around("duplicate()")
	public Object duplicate(ProceedingJoinPoint pjp) throws Throwable {
		LOGGER.debug("进入防重复提交拦截器");
		MethodSignature msig = (MethodSignature) pjp.getSignature();
		Method currentMethod = pjp.getTarget().getClass().getMethod(msig.getName(), msig.getParameterTypes());
		NoDuplicate noDuplicate = currentMethod.getAnnotation(NoDuplicate.class);

		// 拼接签名
		StringBuilder sb = new StringBuilder(currentMethod.toString());
		Object[] args = pjp.getArgs();
		for (Object object : args) {
			if (object != null) {
				sb.append(object.getClass().toString());
				sb.append(JsonUtils.toJson(object));
			}
		}
		String sign = sb.toString();
		RedisLock lock = RedisLockUtils.doLock(currentMethod.getName(), "wms:input:aop:duplicate:sign-" + sign,
				noDuplicate.expireSeconds());
		try {
			return pjp.proceed();
		} finally {
			lock.unlock();
		}
	}
}
