package cn.iisme.framework.aop;

import java.lang.reflect.Method;
import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PrintTakeTimeAop {

	private static final Logger LOGGER = LoggerFactory.getLogger(PrintTakeTimeAop.class);

	@Pointcut("@annotation(cn.iisme.framework.aop.PrintTakeTime)")
	public void takeTime() {
	}

	@Around("takeTime()")
	public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
		long begin = System.nanoTime();
		Object obj = pjp.proceed();
		long end = System.nanoTime();
		MethodSignature msig = (MethodSignature) pjp.getSignature();
		Method currentMethod = pjp.getTarget().getClass().getMethod(msig.getName(), msig.getParameterTypes());
		PrintTakeTime printTakeTime = currentMethod.getAnnotation(PrintTakeTime.class);
		StringBuffer log = new StringBuffer();
		log.append("访问方法:").append(currentMethod.toString());
		if(StringUtils.isNotBlank(printTakeTime.method())) {
			log.append("(").append(printTakeTime.method()).append(")");
		}
		log.append("，");
		log.append("参数：").append(Arrays.toString(pjp.getArgs())).append("，");
		log.append("执行耗时：").append(end - begin).append("纳秒，");
		if(printTakeTime.type() == 1) {
			log.append("耗时：").append((end - begin) / 1000000).append("毫秒，");
		} else if(printTakeTime.type() == 2) {
			log.append("耗时：").append((end - begin) / 1000000 / 1000).append("秒，");
		}
		LOGGER.debug(log.toString());
		return obj;
	}

}
