package cn.iisme.framework.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

import cn.iisme.framework.exception.IException;
import cn.iisme.framework.utils.JsonUtils;

/**
 * APP响应对象
 */
@JsonAutoDetect(fieldVisibility = Visibility.NONE, getterVisibility = Visibility.NONE, setterVisibility = Visibility.NONE, isGetterVisibility = Visibility.NONE, creatorVisibility = Visibility.NONE)
@JsonInclude(Include.NON_NULL)
public class AppResponse<T> extends Response<T> {

	private static final long serialVersionUID = 1L;

	/**
	 * 初始化一个新创建的 AppResponse 对象，使其表示一个空响应。
	 */
	public AppResponse() {
		super();
	}

	/**
	 * 初始化一个新创建的 AppResponse 对象，使其表示一个空响应。
	 */
	public AppResponse(IException exception) {
		this(exception.getCode(), exception.getMessage());
	}

	/**
	 * 初始化一个新创建的 AppResponse 对象
	 * 
	 * @param type
	 *            类型
	 * @param message
	 *            内容
	 */
	public AppResponse(String code, String message) {
		super(code, message);
	}

	/**
	 * 初始化一个新创建的 AppResponse 对象
	 * 
	 * @param type
	 *            类型
	 * @param message
	 *            内容
	 */
	public AppResponse(String code, String message, T data) {
		super(code, message, data);
	}

	/**
	 * 返回成功响应
	 * 
	 * @return 成功响应
	 */
	public static <T> AppResponse<T> success() {
		return new AppResponse<T>(SUCCESS_CODE, SUCCESS_MESSAGE);
	}

	/**
	 * 返回成功响应
	 * 
	 * @return 成功响应
	 */
	public static <T> AppResponse<T> success(String message) {
		return new AppResponse<T>(SUCCESS_CODE, message);
	}

	/**
	 * 返回成功响应
	 * 
	 * @param data
	 *            数据
	 * @return 成功响应
	 */
	public static <T> AppResponse<T> success(T data) {
		return new AppResponse<T>(AppResponse.SUCCESS_CODE, SUCCESS_MESSAGE, data);
	}

	/**
	 * 返回失败响应
	 * 
	 * @return 失败响应
	 */
	public static <T> AppResponse<T> error() {
		return new AppResponse<T>(ERROR_CODE, ERROR_MESSAGE);
	}

	/**
	 * 返回失败响应
	 * 
	 * @param message
	 *            内容
	 * @return 失败响应
	 */
	public static <T> AppResponse<T> error(String message) {
		return new AppResponse<T>(ERROR_CODE, message);
	}

	/**
	 * 返回失败响应
	 * 
	 * @param message
	 *            内容
	 * @return 失败响应
	 */
	public static <T> AppResponse<T> error(String code, String message) {
		return new AppResponse<T>(code, message);
	}

	/**
	 * 返回失败响应
	 * 
	 * @param exception
	 *            异常公共接口
	 * @return 失败响应
	 */
	public static <T> AppResponse<T> error(IException exception) {
		return new AppResponse<T>(exception.getCode(), exception.getMessage());
	}

	@Override
	public String toString() {
		return JsonUtils.toJson(this);
	}

}