package cn.iisme.framework.common;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import cn.iisme.framework.common.Order.Direction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 公共参数 - 列表查询
 */
@ApiModel(description = "公共参数 - 列表查询")
public class FindListReq extends AppRequest {

	private static final long serialVersionUID = 1L;

	/** 搜索属性 */
	@ApiModelProperty(value = "搜索属性", hidden = true)
	private String searchProperty;

	/** 搜索值 */
	@ApiModelProperty(value = "搜索值", hidden = true)
	private String searchValue;

	/** 排序属性 */
	@ApiModelProperty(value = "排序属性", hidden = true)
	private String orderProperty;

	/** 排序方向 */
	@ApiModelProperty(value = "排序方向", hidden = true)
	private Direction orderDirection;

	/** 筛选 */
	@ApiModelProperty(value = "筛选", hidden = true)
	private List<Filter> filters = new ArrayList<Filter>();

	/** 排序 */
	@ApiModelProperty(value = "排序", hidden = true)
	private List<Order> orders = new ArrayList<Order>();

	/**
	 * 初始化一个新创建的Pageable对象
	 */
	public FindListReq() {
	}

	/**
	 * 获取搜索属性
	 * 
	 * @return 搜索属性
	 */
	public String getSearchProperty() {
		return searchProperty;
	}

	/**
	 * 设置搜索属性
	 * 
	 * @param searchProperty 搜索属性
	 */
	public void setSearchProperty(String searchProperty) {
		this.searchProperty = searchProperty;
	}

	/**
	 * 获取搜索值
	 * 
	 * @return 搜索值
	 */
	public String getSearchValue() {
		return searchValue;
	}

	/**
	 * 设置搜索值
	 * 
	 * @param searchValue 搜索值
	 */
	public void setSearchValue(String searchValue) {
		this.searchValue = searchValue;
	}

	/**
	 * 获取排序属性
	 * 
	 * @return 排序属性
	 */
	public String getOrderProperty() {
		return orderProperty;
	}

	/**
	 * 设置排序属性
	 * 
	 * @param orderProperty 排序属性
	 */
	public void setOrderProperty(String orderProperty) {
		this.orderProperty = orderProperty;
	}

	/**
	 * 获取排序方向
	 * 
	 * @return 排序方向
	 */
	public Direction getOrderDirection() {
		return orderDirection;
	}

	/**
	 * 设置排序方向
	 * 
	 * @param orderDirection 排序方向
	 */
	public void setOrderDirection(Direction orderDirection) {
		this.orderDirection = orderDirection;
	}

	/**
	 * 获取筛选
	 * 
	 * @return 筛选
	 */
	public List<Filter> getFilters() {
		return filters;
	}

	/**
	 * 设置筛选
	 * 
	 * @param filters 筛选
	 */
	public void setFilters(List<Filter> filters) {
		this.filters = filters;
	}

	/**
	 * 获取排序
	 * 
	 * @return 排序
	 */
	public List<Order> getOrders() {
		return orders;
	}

	/**
	 * 设置排序
	 * 
	 * @param orders 排序
	 */
	public void setOrders(List<Order> orders) {
		this.orders = orders;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		if (this == obj) {
			return true;
		}
		FindListReq other = (FindListReq) obj;
		return new EqualsBuilder().append(getSearchProperty(), other.getSearchProperty()).append(getSearchValue(), other.getSearchValue())
				.append(getOrderProperty(), other.getOrderProperty()).append(getOrderDirection(), other.getOrderDirection())
				.append(getFilters(), other.getFilters()).append(getOrders(), other.getOrders()).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(getSearchProperty()).append(getSearchValue()).append(getOrderProperty()).append(getOrderDirection())
				.append(getFilters()).append(getOrders()).toHashCode();
	}

	/**
	 * 添加筛选
	 * 
	 * @param filter 筛选
	 */
	public void addFilter(Filter filter) {
		filters.add(filter);
	}

	/**
	 * 添加排序
	 * 
	 * @param order 排序
	 */
	public void addOrder(Order order) {
		orders.add(order);
	}

}