package cn.iisme.framework.common;

import javax.validation.constraints.NotNull;

import cn.iisme.framework.utils.JsonUtils;
import io.swagger.annotations.ApiModelProperty;

/**
 * 请求参数 - ID
 *
 * @作者: yangguangjing
 * @创建时间: 2020年6月3日
 */
public class IdReq extends AppRequest {

	private static final long serialVersionUID = 1L;

	/** ID */
	@NotNull
	@ApiModelProperty(value = "ID")
	private Long id;

	public IdReq() {
		super();
	}

	public IdReq(@NotNull Long id) {
		super();
		this.id = id;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Override
	public String toString() {
		return JsonUtils.toJson(this);
	}

}