package cn.iisme.framework.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import cn.iisme.framework.utils.JsonUtils;
import io.swagger.annotations.ApiModelProperty;

/**
 * 请求参数 - ID列表
 *
 * @作者: yangguangjing
 * @创建时间: 2019年10月15日
 */
public class IdsReq implements Serializable {

	private static final long serialVersionUID = 1L;

	/** ID列表 */
	@ApiModelProperty(value = "ID列表")
	private List<Long> ids = new ArrayList<Long>();

	public List<Long> getIds() {
		return ids;
	}

	public void setIds(List<Long> ids) {
		this.ids = ids;
	}

	@Override
	public String toString() {
		return JsonUtils.toJson(this);
	}

	public static void main(String[] args) {
		IdsReq r = new IdsReq();
		r.setIds(Arrays.asList(1L));
		System.out.println(r.toString());
	}
}