package cn.iisme.framework.common;

import java.io.Serializable;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import cn.iisme.framework.utils.JsonUtils;
import io.swagger.annotations.ApiModelProperty;

/**
 * 树型请求参数
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect(fieldVisibility = Visibility.ANY, getterVisibility = Visibility.ANY, setterVisibility = Visibility.NONE, isGetterVisibility = Visibility.NONE, creatorVisibility = Visibility.NONE)
public class TreeRequest implements Serializable {

	private static final long serialVersionUID = 1L;

	/** 父级ID */
	@ApiModelProperty(value = "父级ID")
	private Long parentId;

	/** 树路径 */
	@ApiModelProperty(value = "树路径", hidden = true)
	private String treePath;

	/** 排序 */
	@Digits(fraction = 0, integer = 4, message = "排序必须为0-9999的数字")
	@Max(value = 9999, message = "排序必须为0-9999的数字")
	@Min(value = 0, message = "排序必须为0-9999的数字")
	@ApiModelProperty(value = "排序")
	private Integer sort;

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getTreePath() {
		return treePath;
	}

	public void setTreePath(String treePath) {
		this.treePath = treePath;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	@Override
	public String toString() {
		return JsonUtils.toJson(this);
	}

}