package cn.iisme.framework.exception;

import com.alibaba.fastjson.JSON;

/**
 * 基本运行时异常
 *
 * @Author:yangguangjing
 * @Date:2019年8月14日
 * @Version:1.0.0
 */
public class BaseException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/** 错误信息 */
	private String message;

	/** 错误代码 */
	private String code = ExceptionCode.EXCEPTION_CODE;

	public BaseException() {
		super();
	}

	public BaseException(Throwable cause) {
		super(cause);
	}

	public BaseException(String message) {
		super(message);
		this.message = message;
	}

	public BaseException(String message, Throwable e) {
		super(message, e);
		this.message = message;
	}

	public BaseException(String code, String message) {
		super(message);
		this.message = message;
		this.code = code;
	}

	public BaseException(String code, String message, Throwable e) {
		super(message, e);
		this.message = message;
		this.code = code;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

}
