package cn.iisme.framework.exception;

import org.slf4j.helpers.MessageFormatter;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * 异常码
 *
 *@Author:yangguangjing
 *@Date:2019年8月14日
 *@Version:1.0.0
 */
@JsonInclude(Include.NON_NULL)
public class ExceptionCode implements IException {

	/** 响应业务异常编码 */
	public static final String EXCEPTION_CODE = "1500";

	/** 编码 */
	private String code;

	/** 内容 */
	private String message;
	
	/** 来源异常原因 */
	private String sourseException;

	/**
	 * 获取编码
	 * 
	 * @return 编码
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 设置编码
	 * 
	 * @param code
	 *            编码
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * 获取内容
	 * 
	 * @return 内容
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * 设置内容
	 * 
	 * @param message
	 *            内容
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	public String getSourseException() {
		return sourseException;
	}

	public void setSourseException(String sourseException) {
		this.sourseException = sourseException;
	}

	/**
	 * 初始化一个新创建的 Head 对象
	 * 
	 * @param type
	 *            编码
	 * @param content
	 *            内容
	 */
	public ExceptionCode(String code, String message) {
		this.code = code;
		this.message = message;
	}

	/**
	 * @param type
	 *            类型
	 * @param content
	 *            内容
	 * @param args
	 *            参数
	 */
	public ExceptionCode(String code, String message, Object... args) {
		this.code = code;
		this.message = MessageFormatter.arrayFormat(message, args).getMessage();
	}

	/**
	 * 返回失败响应
	 * 
	 * @param content
	 *            内容
	 * @param args
	 *            参数
	 * @return 失败响应
	 */
	public static ExceptionCode error(String content, Object... args) {
		return error(ExceptionCode.EXCEPTION_CODE, content, args);
	}

	/**
	 * 返回失败响应
	 * 
	 * @param content
	 *            编码
	 * @param content
	 *            内容
	 * @param args
	 *            参数
	 * @return 失败响应
	 */
	public static ExceptionCode error(String code, String content, Object... args) {
		return new ExceptionCode(code, content, args);
	}

	/**
	 * @功能描述: 填充参数
	 * @Author:yangguangjing
	 * @date:2019年4月19日 上午9:41:25
	 */
	public ExceptionCode fill(Object... args) {
		String msg = MessageFormatter.arrayFormat(this.message, args).getMessage();
		return new ExceptionCode(this.code, msg);
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

}
