package cn.iisme.framework.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

import com.alibaba.fastjson.JSON;

import cn.iisme.framework.utils.JsonUtils;

/**
 * Service异常
 *
 * @Author:yangguangjing
 * @Date:2019年8月14日
 * @Version:1.0.0
 */
public class ServiceException extends BaseException implements IException {

	private static final long serialVersionUID = 1L;

	private static final Logger LOGGER = LoggerFactory.getLogger(ServiceException.class);
	
	/** 来源异常原因 */
	private String sourseException;

	public String getSourseException() {
		return sourseException;
	}

	public ServiceException setSourseException(String sourseException) {
		this.sourseException = sourseException;
		return this;
	}

	public ServiceException() {
		super();
	}

	public ServiceException(Throwable cause) {
		super(cause);
	}

	public ServiceException(String message) {
		super(message);
	}

	public ServiceException(String code, String message, Throwable cause) {
		super(code, message, cause);
	}

	public ServiceException(Integer code, String message) {
		this(String.valueOf(code), message);
	}

	public ServiceException(String code, String message) {
		super(code, message);
	}

	public ServiceException(String code, Throwable cause) {
		super(code, cause);
	}

	public ServiceException(IException exceptionCode) {
		super(String.valueOf(exceptionCode.getCode()), exceptionCode.getMessage());
	}

	public ServiceException(String code, String message, Object... args) {
		super(String.valueOf(code), MessageFormatter.arrayFormat(message, args).getMessage());
	}

	public ServiceException(String message, Object... args) {
		super(MessageFormatter.arrayFormat(message, args).getMessage());
	}

	public static ServiceException error(IException exceptionCode, Object... args) {
		return new ServiceException(exceptionCode.getCode(), exceptionCode.getMessage(), args);
	}

	public static ServiceException error(String message, Object... args) {
		return new ServiceException(message, args);
	}

	public static ServiceException error(Integer code, String message, Object... args) {
		return new ServiceException(String.valueOf(code), message, args);
	}

	@Override
	public String toString() {
		return JSON.toJSONString(this);
	}

	public static void main(String[] args) {
		ServiceException e1 = new ServiceException("404", "找不到页面");
		LOGGER.debug(JsonUtils.toJson(e1));
		ServiceException e2 = new ServiceException("404", "找不到页面{}", "index.html");
		LOGGER.debug(JsonUtils.toJson(e2));
		ServiceException e3 = ServiceException.error("404", "找不到页面{}", "index.html");
		LOGGER.debug(JsonUtils.toJson(e3));
		ServiceException e4 = new ServiceException("找不到页面");
		LOGGER.debug(JsonUtils.toJson(e4));
		ServiceException e5 = new ServiceException(new NullPointerException());
		LOGGER.debug(JsonUtils.toJson(e5));
		ServiceException e6 = new ServiceException("-1", "空指针异常", new NullPointerException());
		LOGGER.debug(JsonUtils.toJson(e6));
	}

}
