/****************************************************************************/
/* 											    					        */
/* Copyright © 2007-2017 qihaiyun.com All Rights Reserved					*/
/* 启海云仓有限公司版权所有													        */
/* 											    					        */
/* PROPRIETARY RIGHTS of Qihaiyun Company are involved in the				*/
/* subject matter of this material. All manufacturing, reproduction, use,	*/
/* and sales rights pertaining to this subject matter are governed by the	*/
/* license agreement. The recipient of this software implicitly accepts		*/
/* the terms of the license.												*/
/* 本软件文档资料是启海云仓有限公司的资产，任何人士阅读和					                    */
/* 使用本资料必须获得相应的书面授权，承担保密责任和接受相应的法律约束。			                */
/* 											    					        */
/****************************************************************************/
package cn.iisme.framework.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * IP工具类
 *
 * @Author:yangguangjing
 * @Date:2019年9月13日
 * @Version:1.0.0
 */
public class IPUtils {

	private static final Logger LOGGER = LoggerFactory.getLogger(IPUtils.class);

	private static String localIpCache = null;

	public static String getLocalIP() {
		if (null != localIpCache) {
			return localIpCache;
		}
		try {
			Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
			while (networkInterfaces.hasMoreElements()) {
				NetworkInterface ni = (NetworkInterface) networkInterfaces.nextElement();
				Enumeration<InetAddress> nias = ni.getInetAddresses();
				while (nias.hasMoreElements()) {
					InetAddress ia = (InetAddress) nias.nextElement();
					if (!ia.isLinkLocalAddress() && !ia.isLoopbackAddress() && ia instanceof Inet4Address) {
						localIpCache = ia.getHostAddress();
						return localIpCache;
					}
				}
			}
		} catch (SocketException e) {
			LOGGER.error("获取ip地址失败,{}", e);
		}
		return "127.0.0.1";
	}

	/**
	 * 
	 * 功能描述：获取真实的IP地址
	 * 
	 * @param request
	 * @return
	 * @author guoyx
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		if (!StringUtils.isBlank(ip) && ip.contains(",")) {
			String[] ips = ip.split(",");
			ip = ips[ips.length - 1];
		}
		// 转换IP 格式
		ip = ip.replace(" ", "");
		return ip;
	}

}
