package cn.iisme.framework.utils;

import java.io.IOException;
import java.io.Writer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

/**
 * Utils - JSON
 *
 * @Author:yangguangjing
 * @Date:2019年8月14日
 * @Version:1.0.0
 */
public final class JsonUtils {

	private static final SerializerFeature[] features = new SerializerFeature[] { 
			SerializerFeature.DisableCircularReferenceDetect,
			SerializerFeature.WriteNullStringAsEmpty, 
			SerializerFeature.WriteNullBooleanAsFalse, 
			SerializerFeature.WriteNullListAsEmpty,
			SerializerFeature.WriteMapNullValue, // 空字段保留
			SerializerFeature.WriteDateUseDateFormat };

	/**
	 * 不可实例化
	 */
	private JsonUtils() {
	}

	/**
	 * 将对象转换为JSON字符串
	 * 
	 * @param value 对象
	 * @return JSOn字符串
	 */
	public static String toJson(Object value) {
		try {
			return JSON.toJSONString(value, features);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 将JSON字符串转换为对象
	 * 
	 * @param json      JSON字符串
	 * @param valueType 对象类型
	 * @return 对象
	 */
	public static <T> T toObject(String json, Class<T> valueType) {
		try {
			return JSON.parseObject(json, valueType);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 将对象转换为JSON流
	 * 
	 * @param writer writer
	 * @param value  对象
	 */
	public static void writeValue(Writer writer, Object value) {
		try {
			writer.write(toJson(value));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
