/****************************************************************************/
/* 											    					        */
/* Copyright © 2007-2017 qihaiyun.com All Rights Reserved					*/
/* 启海云仓有限公司版权所有													        */
/* 											    					        */
/* PROPRIETARY RIGHTS of Qihaiyun Company are involved in the				*/
/* subject matter of this material. All manufacturing, reproduction, use,	*/
/* and sales rights pertaining to this subject matter are governed by the	*/
/* license agreement. The recipient of this software implicitly accepts		*/
/* the terms of the license.												*/
/* 本软件文档资料是启海云仓有限公司的资产，任何人士阅读和					                    */
/* 使用本资料必须获得相应的书面授权，承担保密责任和接受相应的法律约束。			                */
/* 											    					        */
/****************************************************************************/
package cn.iisme.framework.utils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import cn.iisme.framework.exception.ServiceException;
import cn.iisme.starter.redis.common.lock.RedisLock;

/**
 * 分布式锁工具类
 *
 * @Author:yangguangjing
 * @Date:2019年6月27日
 * @Version:1.0.0
 */
@Component
public class RedisLockUtils {

	private static final int LOCK_SECOND = 3600;

	private static RedisLockUtils redisLockUtils;

	@Resource
	private StringRedisTemplate stringRedisTemplate;

	@PostConstruct
	public void init() {
		redisLockUtils = this;
		redisLockUtils.stringRedisTemplate = this.stringRedisTemplate;
	}

	/**
	 * @功能描述: 获取锁
	 * @Author:yangguangjing
	 * @date:2019年6月27日 下午5:17:15
	 */
	public static RedisLock doLock(String method, String lockKey) {
		RedisLock lock = new RedisLock(redisLockUtils.stringRedisTemplate,
				"redisLock:method-" + method + ":lockKey-" + lockKey);
		if (!lock.tryLock(LOCK_SECOND)) {
			throw new ServiceException("正在处理中，请稍后重试");
		}
		return lock;
	}

	/**
	 * @功能描述: 获取锁
	 * @Author:yangguangjing
	 * @date:2019年6月27日 下午5:17:15
	 */
	public static RedisLock doLock(String method, String lockKey, int lockSecond) {
		RedisLock lock = new RedisLock(redisLockUtils.stringRedisTemplate,
				"redisLock:method-" + method + ":lockKey-" + lockKey);
		if (!lock.tryLock(lockSecond)) {
			throw new ServiceException("正在处理中，请稍后重试");
		}
		return lock;
	}

	/**
	 * 轮询的方式去获得锁，成功返回true，超过轮询次数或异常返回false
	 *
	 * @param lockSeconds       加锁的时间(秒)，超过这个时间后锁会自动释放
	 * @param tryIntervalMillis 轮询的时间间隔(毫秒)
	 * @param maxTryCount       最大的轮询次数
	 * 
	 * @Author:yangguangjing
	 * @date:2019年6月27日 下午5:17:15
	 */
	public static RedisLock doLock(String method, String lockKey, int lockSeconds, long tryIntervalMillis, int maxTryCount) {
		RedisLock lock = new RedisLock(redisLockUtils.stringRedisTemplate,
				"redisLock:method-" + method + ":lockKey-" + lockKey);
		if (!lock.tryLock(lockSeconds, tryIntervalMillis, maxTryCount)) {
			throw new ServiceException("正在处理中，请稍后重试");
		}
		return lock;
	}

}
