package cn.iisme.framework.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Utils - 签名工具类
 */
public class SignUtils {

	private static Logger logger = LoggerFactory.getLogger(SignUtils.class);

	/**
	 * 生成签名
	 * @param params
	 * 			参数
	 * @param secret
	 * 			密钥
	 * @return
	 */
	public static String buildMD5Sign(Map<String, Object> params, String secret) {
		Map<String, Object> treeMap = new TreeMap<String, Object>(params);// treeMap默认会以key值升序排序
		logger.debug(treeMap.toString());
		StringBuffer sb = new StringBuffer("");
		for (String key : treeMap.keySet()) {// 排序后的字典，将所有参数按"key=value"格式拼接在一起
			if(treeMap.get(key) != null) {
				sb.append(treeMap.get(key).toString());
			}
		}
		sb.append(secret);
		return buildMD5Sign(sb.toString(), secret);
	}
	
	/**
	 * 生成签名
	 * @param params
	 * 			参数
	 * @param secret
	 * 			密钥
	 * @return
	 */
	public static String buildMD5Sign(String content, String secret) {
		logger.debug("待加密的源参数串为:" + content);
		MessageDigest md5;
		byte[] bytes = null;
		try {
			md5 = MessageDigest.getInstance("MD5");
			bytes = md5.digest(content.getBytes("UTF-8"));// md5加密
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		// 将MD5输出的二进制结果转换为小写的十六进制
		StringBuilder sign = new StringBuilder();
		for (int i = 0; i < bytes.length; i++) {
			String hex = Integer.toHexString(bytes[i] & 0xFF);
			if (hex.length() == 1) {
				sign.append("0");
			}
			sign.append(hex);
		}
		logger.debug("加密后签名为:" + sign.toString());
		return sign.toString();
	}
	
}
