package cn.iisme.framework.validate;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

import cn.iisme.framework.exception.BaseException;

/**
 * hibernate-validator校验工具类
 *
 * 参考文档：http://docs.jboss.org/hibernate/validator/5.4/reference/en-US/html_single/
 *
 * @Author:yangguangjing
 * @Date:2019年8月14日
 * @Version:1.0.0
 */
public class ValidatorUtils {

	private static Validator validator;

	static {
		validator = Validation.buildDefaultValidatorFactory().getValidator();
	}

	/**
	 * 校验对象
	 * 
	 * @param object
	 *            待校验对象
	 * @param groups
	 *            待校验的组
	 * @throws RRException
	 *             校验不通过，则报RRException异常
	 */
	public static void validateEntity(Object object, Class<?>... groups) throws BaseException {
		Set<ConstraintViolation<Object>> constraintViolations = validator.validate(object, groups);
		if (!constraintViolations.isEmpty()) {
			ConstraintViolation<Object> constraint = (ConstraintViolation<Object>) constraintViolations.iterator()
					.next();
			throw new BaseException(constraint.getMessage());
		}
	}

	/**
	 * 校验对象属性
	 * 
	 * @param object
	 *            待校验对象
	 * @param property
	 *            待校验的属性
	 * @param groups
	 *            待校验的组
	 * @throws BaseException
	 *             校验不通过，则报BaseException异常
	 */
	public static void validateProperty(Object object, String property, Class<?>... groups) {
		Set<ConstraintViolation<Object>> constraintViolations = validator.validateProperty(object, property, groups);
		if (!constraintViolations.isEmpty()) {
			ConstraintViolation<Object> constraint = (ConstraintViolation<Object>) constraintViolations.iterator()
					.next();
			throw new BaseException(constraint.getMessage());
		}
	}

	/**
	 * 校验属性值
	 * 
	 * @param type
	 *            待校验的类型
	 * @param property
	 *            待校验的属性
	 * @param value
	 *            待校验的值
	 * @param groups
	 *            待校验的组
	 * @throws BaseException
	 *             校验不通过，则报BaseException异常
	 */
	public static void validateValue(Class<?> type, String property, Object value, Class<?>... groups) {
		Set<?> constraintViolations = validator.validateValue(type, property, value, groups);
		if (!constraintViolations.isEmpty()) {
			ConstraintViolation<?> constraint = (ConstraintViolation<?>) constraintViolations.iterator().next();
			throw new BaseException(constraint.getMessage());
		}
	}

}
