/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.core.beans.creator;

import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.core.exception.BeanCreationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class BeanFactoryCreator
implements BeanCreator {
    private AutumnContext context;
    private Method factoryMethod;
    private boolean isStatic;

    public BeanFactoryCreator(AutumnContext context, Method factoryMethod) {
        this.context = context;
        this.factoryMethod = factoryMethod;
        this.isStatic = Modifier.isStatic(factoryMethod.getModifiers());
    }

    @Override
    public Object createBean() throws BeanCreationException {
        try {
            if (this.isStatic) {
                return this.factoryMethod.invoke(null, new Object[0]);
            }
            Class<?> factoryClass = this.factoryMethod.getDeclaringClass();
            Object factoryInstance = this.context.getBeanByType(factoryClass);
            if (factoryInstance == null) {
                throw new BeanCreationException("Cannot get bean for factory " + factoryClass.getName());
            }
            return this.factoryMethod.invoke(factoryInstance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new BeanCreationException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanCreationException(e.getCause());
        }
    }
}

