/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.core.beans.populator;

import cn.imaq.autumn.core.beans.populator.AnnotatedFieldPopulator;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.core.exception.BeanPopulationException;
import cn.imaq.autumn.cpscan.AutumnClasspathScan;
import cn.imaq.autumn.cpscan.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPopulators {
    private static final Logger log = LoggerFactory.getLogger(BeanPopulators.class);
    private static Map<Class<? extends Annotation>, AnnotatedFieldPopulator<?>> annotatedFieldPopulatorMap = new HashMap();
    private static volatile boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInit() {
        if (init) return;
        Class<BeanPopulators> clazz = BeanPopulators.class;
        synchronized (BeanPopulators.class) {
            if (init) return;
            log.info("Init bean populators ...");
            ScanResult result = AutumnClasspathScan.getGlobalScanResult();
            result.getSubClassesOf(AnnotatedFieldPopulator.class).forEach(c -> {
                try {
                    AnnotatedFieldPopulator populator = (AnnotatedFieldPopulator)c.newInstance();
                    Class annotationClass = populator.getAnnotationClass();
                    if (annotationClass != null) {
                        annotatedFieldPopulatorMap.put(annotationClass, populator);
                    }
                }
                catch (Exception e) {
                    log.warn("Cannot init bean populator [{}]: {}", c, (Object)String.valueOf(e));
                }
            });
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void populateBean(AutumnContext context, Object instance) throws BeanPopulationException {
        BeanPopulators.ensureInit();
        block2: for (Field field : instance.getClass().getDeclaredFields()) {
            try {
                for (Class<? extends Annotation> annoClass : annotatedFieldPopulatorMap.keySet()) {
                    if (!field.isAnnotationPresent(annoClass)) continue;
                    Object value = annotatedFieldPopulatorMap.get(annoClass).populate(context, field);
                    field.setAccessible(true);
                    field.set(instance, value);
                    continue block2;
                }
            }
            catch (Exception e) {
                throw new BeanPopulationException("Unable to inject field " + field + ": " + e);
            }
        }
    }
}

