/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.core.beans.processor;

import cn.imaq.autumn.core.beans.processor.BeanProcessor;
import cn.imaq.autumn.cpscan.AutumnClasspathScan;
import cn.imaq.autumn.cpscan.ScanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProcessors {
    private static final Logger log = LoggerFactory.getLogger(BeanProcessors.class);
    private static Map<Class<? extends BeanProcessor>, List<BeanProcessor>> beanProcessors = new HashMap<Class<? extends BeanProcessor>, List<BeanProcessor>>();
    private static volatile boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInit() {
        if (init) return;
        Class<BeanProcessors> clazz = BeanProcessors.class;
        synchronized (BeanProcessors.class) {
            if (init) return;
            log.info("Init bean processors ...");
            ScanResult result = AutumnClasspathScan.getGlobalScanResult();
            result.getClassesImplementing(BeanProcessor.class).forEach(c -> {
                try {
                    Class processorClass = c;
                    BeanProcessor processor = (BeanProcessor)processorClass.newInstance();
                    for (Class<?> intf : processorClass.getInterfaces()) {
                        if (!BeanProcessor.class.isAssignableFrom(intf)) continue;
                        beanProcessors.computeIfAbsent(intf, x -> new ArrayList()).add(processor);
                    }
                }
                catch (Exception e) {
                    log.warn("Cannot init bean processor [{}]: {}", c, (Object)String.valueOf(e));
                }
            });
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static <T extends BeanProcessor> List<T> get(Class<T> processorClass) {
        BeanProcessors.ensureInit();
        List<BeanProcessor> processors = beanProcessors.get(processorClass);
        if (processors == null) {
            return Collections.emptyList();
        }
        return processors;
    }
}

