/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.core.beans.scanner;

import cn.imaq.autumn.core.beans.scanner.BeanScanner;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.cpscan.ScanResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanScanners {
    private static final Logger log = LoggerFactory.getLogger(BeanScanners.class);
    private static volatile List<BeanScanner> scanners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void processAll(ScanResult result, AutumnContext context) {
        if (scanners == null) {
            Class<BeanScanners> clazz = BeanScanners.class;
            // MONITORENTER : cn.imaq.autumn.core.beans.scanner.BeanScanners.class
            if (scanners == null) {
                log.info("Init bean scanners ...");
                scanners = new ArrayList<BeanScanner>();
                result.getClassesImplementing(BeanScanner.class).forEach(c -> {
                    try {
                        scanners.add((BeanScanner)c.newInstance());
                    }
                    catch (Exception e) {
                        log.warn("Cannot init bean scanner [{}]: {}", c, (Object)String.valueOf(e));
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        scanners.forEach(sc -> sc.process(result, context));
    }
}

